/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.elasticsearch.jest;

import com.google.gson.Gson;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.config.HttpClientConfig;
import java.time.Duration;
import org.apache.http.HttpHost;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.elasticsearch.jest.HttpClientConfigBuilderCustomizer;
import org.springframework.boot.autoconfigure.elasticsearch.jest.JestProperties;
import org.springframework.boot.autoconfigure.gson.GsonAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;

@Configuration
@ConditionalOnClass(value={JestClient.class})
@EnableConfigurationProperties(value={JestProperties.class})
@AutoConfigureAfter(value={GsonAutoConfiguration.class})
public class JestAutoConfiguration {
    private final JestProperties properties;
    private final ObjectProvider<Gson> gsonProvider;
    private final ObjectProvider<HttpClientConfigBuilderCustomizer> builderCustomizers;

    public JestAutoConfiguration(JestProperties properties, ObjectProvider<Gson> gson, ObjectProvider<HttpClientConfigBuilderCustomizer> builderCustomizers) {
        this.properties = properties;
        this.gsonProvider = gson;
        this.builderCustomizers = builderCustomizers;
    }

    @Bean(destroyMethod="shutdownClient")
    @ConditionalOnMissingBean
    public JestClient jestClient() {
        JestClientFactory factory = new JestClientFactory();
        factory.setHttpClientConfig(this.createHttpClientConfig());
        return factory.getObject();
    }

    protected HttpClientConfig createHttpClientConfig() {
        HttpClientConfig.Builder builder = new HttpClientConfig.Builder(this.properties.getUris());
        PropertyMapper map = PropertyMapper.get();
        map.from(this.properties::getUsername).whenHasText().to(username -> builder.defaultCredentials(username, this.properties.getPassword()));
        JestProperties.Proxy proxy = this.properties.getProxy();
        map.from(proxy::getHost).whenHasText().to(host -> {
            Assert.notNull((Object)proxy.getPort(), (String)"Proxy port must not be null");
            builder.proxy(new HttpHost(host, proxy.getPort().intValue()));
        });
        map.from(() -> this.gsonProvider.getIfUnique()).whenNonNull().to(x$0 -> builder.gson(x$0));
        map.from(this.properties::isMultiThreaded).to(x$0 -> builder.multiThreaded(x$0));
        map.from(this.properties::getConnectionTimeout).whenNonNull().asInt(Duration::toMillis).to(x$0 -> builder.connTimeout(x$0));
        map.from(this.properties::getReadTimeout).whenNonNull().asInt(Duration::toMillis).to(x$0 -> builder.readTimeout(x$0));
        this.customize(builder);
        return builder.build();
    }

    private void customize(HttpClientConfig.Builder builder) {
        this.builderCustomizers.orderedStream().forEach(customizer -> customizer.customize(builder));
    }
}

