/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jms;

import java.util.Arrays;
import javax.jms.ConnectionFactory;
import javax.naming.NamingException;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnJndi;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jms.JmsAutoConfiguration;
import org.springframework.boot.autoconfigure.jms.JmsProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jndi.JndiLocatorDelegate;
import org.springframework.util.StringUtils;

@Configuration
@AutoConfigureBefore(value={JmsAutoConfiguration.class})
@ConditionalOnClass(value={JmsTemplate.class})
@ConditionalOnMissingBean(value={ConnectionFactory.class})
@Conditional(value={JndiOrPropertyCondition.class})
@EnableConfigurationProperties(value={JmsProperties.class})
public class JndiConnectionFactoryAutoConfiguration {
    private static final String[] JNDI_LOCATIONS = new String[]{"java:/JmsXA", "java:/XAConnectionFactory"};
    private final JmsProperties properties;

    public JndiConnectionFactoryAutoConfiguration(JmsProperties properties) {
        this.properties = properties;
    }

    @Bean
    public ConnectionFactory connectionFactory() throws NamingException {
        if (StringUtils.hasLength((String)this.properties.getJndiName())) {
            return (ConnectionFactory)new JndiLocatorDelegate().lookup(this.properties.getJndiName(), ConnectionFactory.class);
        }
        return this.findJndiConnectionFactory();
    }

    private ConnectionFactory findJndiConnectionFactory() {
        for (String name : JNDI_LOCATIONS) {
            try {
                return (ConnectionFactory)new JndiLocatorDelegate().lookup(name, ConnectionFactory.class);
            }
            catch (NamingException namingException) {
            }
        }
        throw new IllegalStateException("Unable to find ConnectionFactory in JNDI locations " + Arrays.asList(JNDI_LOCATIONS));
    }

    static class JndiOrPropertyCondition
    extends AnyNestedCondition {
        JndiOrPropertyCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(prefix="spring.jms", name={"jndi-name"})
        static class Property {
            Property() {
            }
        }

        @ConditionalOnJndi(value={"java:/JmsXA", "java:/XAConnectionFactory"})
        static class Jndi {
            Jndi() {
            }
        }
    }
}

