/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.websocket;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.apache.catalina.Context;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.websocket.WebSocketContainerCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class TomcatWebSocketContainerCustomizer
extends WebSocketContainerCustomizer<TomcatEmbeddedServletContainerFactory> {
    private static final String TOMCAT_7_LISTENER_TYPE = "org.apache.catalina.deploy.ApplicationListener";
    private static final String TOMCAT_8_LISTENER_TYPE = "org.apache.tomcat.util.descriptor.web.ApplicationListener";
    private static final String WS_LISTENER = "org.apache.tomcat.websocket.server.WsContextListener";

    @Override
    public void doCustomize(TomcatEmbeddedServletContainerFactory tomcatContainer) {
        tomcatContainer.addContextCustomizers(new TomcatContextCustomizer[]{new TomcatContextCustomizer(){

            public void customize(Context context) {
                TomcatWebSocketContainerCustomizer.this.addListener(context, TomcatWebSocketContainerCustomizer.this.findListenerType());
            }
        }});
    }

    private Class<?> findListenerType() {
        if (ClassUtils.isPresent((String)TOMCAT_7_LISTENER_TYPE, null)) {
            return ClassUtils.resolveClassName((String)TOMCAT_7_LISTENER_TYPE, null);
        }
        if (ClassUtils.isPresent((String)TOMCAT_8_LISTENER_TYPE, null)) {
            return ClassUtils.resolveClassName((String)TOMCAT_8_LISTENER_TYPE, null);
        }
        return null;
    }

    private void addListener(Context context, Class<?> listenerType) {
        Class<?> contextClass = context.getClass();
        if (listenerType == null) {
            ReflectionUtils.invokeMethod((Method)ClassUtils.getMethod(contextClass, (String)"addApplicationListener", (Class[])new Class[]{String.class}), (Object)context, (Object[])new Object[]{WS_LISTENER});
        } else {
            Constructor constructor = ClassUtils.getConstructorIfAvailable(listenerType, (Class[])new Class[]{String.class, Boolean.TYPE});
            Object instance = BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{WS_LISTENER, false});
            ReflectionUtils.invokeMethod((Method)ClassUtils.getMethod(contextClass, (String)"addApplicationListener", (Class[])new Class[]{listenerType}), (Object)context, (Object[])new Object[]{instance});
        }
    }
}

