/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import org.springframework.boot.autoconfigure.template.TemplateAvailabilityProvider;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.ClassUtils;

public class JspTemplateAvailabilityProvider
implements TemplateAvailabilityProvider {
    @Override
    public boolean isTemplateAvailable(String view, Environment environment, ClassLoader classLoader, ResourceLoader resourceLoader) {
        if (ClassUtils.isPresent((String)"org.apache.jasper.compiler.JspConfig", (ClassLoader)classLoader)) {
            String resourceName = this.getResourceName(view, environment);
            return resourceLoader.getResource(resourceName).exists();
        }
        return false;
    }

    private String getResourceName(String view, Environment environment) {
        RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)environment, "spring.mvc.view.");
        String prefix = resolver.getProperty("prefix", WebMvcAutoConfiguration.DEFAULT_PREFIX);
        String suffix = resolver.getProperty("suffix", WebMvcAutoConfiguration.DEFAULT_SUFFIX);
        return prefix + view + suffix;
    }
}

