/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import org.springframework.util.ObjectUtils;

public class ConditionOutcome {
    private final boolean match;
    private final String message;

    public ConditionOutcome(boolean match, String message) {
        this.match = match;
        this.message = message;
    }

    public static ConditionOutcome match() {
        return ConditionOutcome.match(null);
    }

    public static ConditionOutcome match(String message) {
        return new ConditionOutcome(true, message);
    }

    public static ConditionOutcome noMatch(String message) {
        return new ConditionOutcome(false, message);
    }

    public boolean isMatch() {
        return this.match;
    }

    public String getMessage() {
        return this.message;
    }

    public int hashCode() {
        return ObjectUtils.hashCode((boolean)this.match) * 31 + ObjectUtils.nullSafeHashCode((Object)this.message);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            ConditionOutcome other = (ConditionOutcome)obj;
            return this.match == other.match && ObjectUtils.nullSafeEquals((Object)this.message, (Object)other.message);
        }
        return super.equals(obj);
    }

    public String toString() {
        return this.message == null ? "" : this.message;
    }

    public static ConditionOutcome inverse(ConditionOutcome outcome) {
        return new ConditionOutcome(!outcome.isMatch(), outcome.getMessage());
    }
}

