/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.hateoas;

import java.util.Arrays;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.mvc.TypeConstrainedMappingJackson2HttpMessageConverter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

public class HypermediaHttpMessageConverterConfiguration {
    @Bean
    @ConditionalOnProperty(prefix="spring.hateoas", name={"use-hal-as-default-json-media-type"}, matchIfMissing=true)
    public static HalMessageConverterSupportedMediaTypesCustomizer halMessageConverterSupportedMediaTypeCustomizer() {
        return new HalMessageConverterSupportedMediaTypesCustomizer();
    }

    private static class HalMessageConverterSupportedMediaTypesCustomizer
    implements BeanFactoryAware {
        private volatile BeanFactory beanFactory;

        private HalMessageConverterSupportedMediaTypesCustomizer() {
        }

        @PostConstruct
        public void customizedSupportedMediaTypes() {
            if (this.beanFactory instanceof ListableBeanFactory) {
                Map handlerAdapters = ((ListableBeanFactory)this.beanFactory).getBeansOfType(RequestMappingHandlerAdapter.class);
                for (Map.Entry entry : handlerAdapters.entrySet()) {
                    RequestMappingHandlerAdapter handlerAdapter = (RequestMappingHandlerAdapter)entry.getValue();
                    for (HttpMessageConverter converter : handlerAdapter.getMessageConverters()) {
                        if (!(converter instanceof TypeConstrainedMappingJackson2HttpMessageConverter)) continue;
                        ((TypeConstrainedMappingJackson2HttpMessageConverter)converter).setSupportedMediaTypes(Arrays.asList(MediaTypes.HAL_JSON, MediaType.APPLICATION_JSON));
                    }
                }
            }
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = beanFactory;
        }
    }
}

