/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.websocket;

import io.undertow.websockets.jsr.Bootstrap;
import javax.servlet.Servlet;
import javax.websocket.server.ServerContainer;
import org.apache.catalina.startup.Tomcat;
import org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.EmbeddedServletContainerAutoConfiguration;
import org.springframework.boot.autoconfigure.websocket.JettyWebSocketContainerCustomizer;
import org.springframework.boot.autoconfigure.websocket.TomcatWebSocketContainerCustomizer;
import org.springframework.boot.autoconfigure.websocket.UndertowWebSocketContainerCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Servlet.class, ServerContainer.class})
@ConditionalOnWebApplication
@AutoConfigureBefore(value={EmbeddedServletContainerAutoConfiguration.class})
public class WebSocketAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={Bootstrap.class})
    static class UndertowWebSocketConfiguration {
        UndertowWebSocketConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"websocketContainerCustomizer"})
        public UndertowWebSocketContainerCustomizer websocketContainerCustomizer() {
            return new UndertowWebSocketContainerCustomizer();
        }
    }

    @Configuration
    @ConditionalOnClass(value={WebSocketServerContainerInitializer.class})
    static class JettyWebSocketConfiguration {
        JettyWebSocketConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"websocketContainerCustomizer"})
        public JettyWebSocketContainerCustomizer websocketContainerCustomizer() {
            return new JettyWebSocketContainerCustomizer();
        }
    }

    @Configuration
    @ConditionalOnClass(name={"org.apache.tomcat.websocket.server.WsSci"}, value={Tomcat.class})
    static class TomcatWebSocketConfiguration {
        TomcatWebSocketConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"websocketContainerCustomizer"})
        public TomcatWebSocketContainerCustomizer websocketContainerCustomizer() {
            return new TomcatWebSocketContainerCustomizer();
        }
    }
}

