/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jms;

import javax.jms.ConnectionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jms.JmsProperties;
import org.springframework.boot.autoconfigure.jms.activemq.ActiveMQAutoConfiguration;
import org.springframework.boot.autoconfigure.jms.hornetq.HornetQAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.core.JmsTemplate;

@Configuration
@ConditionalOnClass(value={JmsTemplate.class})
@ConditionalOnBean(value={ConnectionFactory.class})
@EnableConfigurationProperties(value={JmsProperties.class})
@AutoConfigureAfter(value={HornetQAutoConfiguration.class, ActiveMQAutoConfiguration.class})
public class JmsAutoConfiguration {
    @Autowired
    private JmsProperties properties;
    @Autowired
    private ConnectionFactory connectionFactory;

    @Bean
    @ConditionalOnMissingBean
    public JmsTemplate jmsTemplate() {
        JmsTemplate jmsTemplate = new JmsTemplate(this.connectionFactory);
        jmsTemplate.setPubSubDomain(this.properties.isPubSubDomain());
        return jmsTemplate;
    }
}

