/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.autoconfigure.web.HttpMapperProperties;
import org.springframework.boot.autoconfigure.web.HttpMessageConverters;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

@Configuration
@ConditionalOnClass(value={HttpMessageConverter.class})
@Import(value={JacksonAutoConfiguration.class})
public class HttpMessageConvertersAutoConfiguration {
    @Autowired(required=false)
    private final List<HttpMessageConverter<?>> converters = Collections.emptyList();

    @Bean
    @ConditionalOnMissingBean
    public HttpMessageConverters messageConverters() {
        ArrayList converters = new ArrayList(this.converters);
        return new HttpMessageConverters(converters);
    }

    @Configuration
    @ConditionalOnClass(value={ObjectMapper.class})
    @EnableConfigurationProperties(value={HttpMapperProperties.class})
    protected static class ObjectMappers {
        @Autowired
        private HttpMapperProperties properties = new HttpMapperProperties();

        protected ObjectMappers() {
        }

        @Bean
        @ConditionalOnMissingBean
        public MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter(ObjectMapper objectMapper) {
            MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
            converter.setObjectMapper(objectMapper);
            converter.setPrettyPrint(this.properties.isJsonPrettyPrint());
            return converter;
        }
    }
}

