/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mongo;

import com.mongodb.Mongo;
import java.net.UnknownHostException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;
import org.springframework.data.mongodb.gridfs.GridFsTemplate;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={Mongo.class, MongoTemplate.class})
@ConditionalOnBean(value={MongoProperties.class})
@AutoConfigureAfter(value={MongoAutoConfiguration.class})
public class MongoDataAutoConfiguration {
    @Autowired
    private MongoProperties properties;

    @Bean
    @ConditionalOnMissingBean
    public MongoDbFactory mongoDbFactory(Mongo mongo) throws Exception {
        String db = this.properties.getMongoClientDatabase();
        return new SimpleMongoDbFactory(mongo, db);
    }

    @Bean
    @ConditionalOnMissingBean
    public MongoTemplate mongoTemplate(MongoDbFactory mongoDbFactory) throws UnknownHostException {
        return new MongoTemplate(mongoDbFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    public GridFsTemplate gridFsTemplate(Mongo mongo, MongoTemplate mongoTemplate) {
        String db = StringUtils.hasText((String)this.properties.getGridFsDatabase()) ? this.properties.getGridFsDatabase() : this.properties.getMongoClientDatabase();
        return new GridFsTemplate((MongoDbFactory)new SimpleMongoDbFactory(mongo, db), mongoTemplate.getConverter());
    }
}

