/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jms.activemq;

import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.transport.vm.VMTransportFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.jms.JmsAutoConfiguration;
import org.springframework.boot.autoconfigure.jms.activemq.ActiveMQConnectionFactoryConfiguration;
import org.springframework.boot.autoconfigure.jms.activemq.ActiveMQProperties;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
@AutoConfigureBefore(value={JmsAutoConfiguration.class})
@ConditionalOnClass(value={ConnectionFactory.class, ActiveMQConnectionFactory.class})
@ConditionalOnMissingBean(value={ConnectionFactory.class})
public class ActiveMQAutoConfiguration {

    static class NonEmbeddedBrokerCondition
    extends BrokerTypeCondition {
        NonEmbeddedBrokerCondition() {
            super(false);
        }
    }

    static class EmbeddedBrokerCondition
    extends BrokerTypeCondition {
        EmbeddedBrokerCondition() {
            super(true);
        }
    }

    static abstract class BrokerTypeCondition
    extends SpringBootCondition {
        private final boolean embedded;

        BrokerTypeCondition(boolean embedded) {
            this.embedded = embedded;
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            String brokerUrl = ActiveMQProperties.determineBrokerUrl(context.getEnvironment());
            boolean match = brokerUrl.contains("vm://");
            boolean outcome = match == this.embedded;
            return new ConditionOutcome(outcome, this.buildMessage(brokerUrl, outcome));
        }

        protected String buildMessage(String brokerUrl, boolean outcome) {
            String brokerType = this.embedded ? "Embedded" : "Network";
            String detected = outcome ? "detected" : "not detected";
            return brokerType + " ActiveMQ broker " + detected + " - brokerUrl '" + brokerUrl + "'";
        }
    }

    @Configuration
    @Conditional(value={NonEmbeddedBrokerCondition.class})
    @Import(value={ActiveMQConnectionFactoryConfiguration.class})
    protected static class NetworkBroker {
        protected NetworkBroker() {
        }
    }

    @Configuration
    @ConditionalOnClass(value={VMTransportFactory.class})
    @Conditional(value={EmbeddedBrokerCondition.class})
    @Import(value={ActiveMQConnectionFactoryConfiguration.class})
    protected static class EmbeddedBroker {
        protected EmbeddedBroker() {
        }
    }
}

