/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.amqp.autoconfigure.health;

import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.amqp.autoconfigure.RabbitAutoConfiguration;
import org.springframework.boot.amqp.health.RabbitHealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.health.autoconfigure.contributor.CompositeHealthContributorConfiguration;
import org.springframework.boot.health.autoconfigure.contributor.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.health.contributor.HealthContributor;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={RabbitAutoConfiguration.class})
@ConditionalOnClass(value={RabbitHealthIndicator.class, RabbitTemplate.class, ConditionalOnEnabledHealthIndicator.class})
@ConditionalOnBean(value={RabbitTemplate.class})
@ConditionalOnEnabledHealthIndicator(value="rabbit")
public final class RabbitHealthContributorAutoConfiguration
extends CompositeHealthContributorConfiguration<RabbitHealthIndicator, RabbitTemplate> {
    RabbitHealthContributorAutoConfiguration() {
        super(RabbitHealthIndicator::new);
    }

    @Bean
    @ConditionalOnMissingBean(name={"rabbitHealthIndicator", "rabbitHealthContributor"})
    HealthContributor rabbitHealthContributor(ConfigurableListableBeanFactory beanFactory) {
        return (HealthContributor)this.createContributor(beanFactory, RabbitTemplate.class);
    }
}

