/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.amqp.autoconfigure;

import com.rabbitmq.client.impl.CredentialsProvider;
import com.rabbitmq.client.impl.CredentialsRefreshService;
import java.time.Duration;
import org.springframework.amqp.rabbit.connection.RabbitConnectionFactoryBean;
import org.springframework.boot.amqp.autoconfigure.PropertiesRabbitConnectionDetails;
import org.springframework.boot.amqp.autoconfigure.RabbitConnectionDetails;
import org.springframework.boot.amqp.autoconfigure.RabbitProperties;
import org.springframework.boot.amqp.autoconfigure.SslBundleRabbitConnectionFactoryBean;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.unit.DataSize;

public class RabbitConnectionFactoryBeanConfigurer {
    private final RabbitProperties rabbitProperties;
    private final ResourceLoader resourceLoader;
    private final RabbitConnectionDetails connectionDetails;
    private CredentialsProvider credentialsProvider;
    private CredentialsRefreshService credentialsRefreshService;

    public RabbitConnectionFactoryBeanConfigurer(ResourceLoader resourceLoader, RabbitProperties properties) {
        this(resourceLoader, properties, new PropertiesRabbitConnectionDetails(properties, null));
    }

    public RabbitConnectionFactoryBeanConfigurer(ResourceLoader resourceLoader, RabbitProperties properties, RabbitConnectionDetails connectionDetails) {
        this(resourceLoader, properties, connectionDetails, null);
    }

    public RabbitConnectionFactoryBeanConfigurer(ResourceLoader resourceLoader, RabbitProperties properties, RabbitConnectionDetails connectionDetails, SslBundles sslBundles) {
        Assert.notNull((Object)resourceLoader, (String)"'resourceLoader' must not be null");
        Assert.notNull((Object)properties, (String)"'properties' must not be null");
        Assert.notNull((Object)connectionDetails, (String)"'connectionDetails' must not be null");
        this.resourceLoader = resourceLoader;
        this.rabbitProperties = properties;
        this.connectionDetails = connectionDetails;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public void setCredentialsRefreshService(CredentialsRefreshService credentialsRefreshService) {
        this.credentialsRefreshService = credentialsRefreshService;
    }

    public void configure(RabbitConnectionFactoryBean factory) {
        Assert.notNull((Object)factory, (String)"'factory' must not be null");
        factory.setResourceLoader(this.resourceLoader);
        RabbitConnectionDetails.Address address = this.connectionDetails.getFirstAddress();
        PropertyMapper map = PropertyMapper.get();
        map.from(address::host).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setHost(arg_0));
        map.from(address::port).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setPort(arg_0));
        map.from(this.connectionDetails::getUsername).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setUsername(arg_0));
        map.from(this.connectionDetails::getPassword).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setPassword(arg_0));
        map.from(this.connectionDetails::getVirtualHost).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setVirtualHost(arg_0));
        map.from(this.rabbitProperties::getRequestedHeartbeat).whenNonNull().asInt(Duration::getSeconds).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setRequestedHeartbeat(arg_0));
        map.from(this.rabbitProperties::getRequestedChannelMax).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setRequestedChannelMax(arg_0));
        SslBundle sslBundle = this.connectionDetails.getSslBundle();
        if (sslBundle != null) {
            RabbitConnectionFactoryBeanConfigurer.applySslBundle(factory, sslBundle);
        } else {
            RabbitProperties.Ssl ssl = this.rabbitProperties.getSsl();
            if (ssl.determineEnabled()) {
                factory.setUseSSL(true);
                map.from(ssl::getAlgorithm).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setSslAlgorithm(arg_0));
                map.from(ssl::getKeyStoreType).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setKeyStoreType(arg_0));
                map.from(ssl::getKeyStore).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setKeyStore(arg_0));
                map.from(ssl::getKeyStorePassword).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setKeyStorePassphrase(arg_0));
                map.from(ssl::getKeyStoreAlgorithm).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setKeyStoreAlgorithm(arg_0));
                map.from(ssl::getTrustStoreType).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setTrustStoreType(arg_0));
                map.from(ssl::getTrustStore).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setTrustStore(arg_0));
                map.from(ssl::getTrustStorePassword).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setTrustStorePassphrase(arg_0));
                map.from(ssl::getTrustStoreAlgorithm).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setTrustStoreAlgorithm(arg_0));
                map.from(ssl::isValidateServerCertificate).to(validate -> factory.setSkipServerCertificateValidation(validate == false));
                map.from(ssl::isVerifyHostname).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setEnableHostnameVerification(arg_0));
            }
        }
        map.from(this.rabbitProperties::getConnectionTimeout).whenNonNull().asInt(Duration::toMillis).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setConnectionTimeout(arg_0));
        map.from(this.rabbitProperties::getChannelRpcTimeout).whenNonNull().asInt(Duration::toMillis).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setChannelRpcTimeout(arg_0));
        map.from((Object)this.credentialsProvider).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setCredentialsProvider(arg_0));
        map.from((Object)this.credentialsRefreshService).whenNonNull().to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setCredentialsRefreshService(arg_0));
        map.from((Object)this.rabbitProperties.getMaxInboundMessageBodySize()).whenNonNull().asInt(DataSize::toBytes).to(arg_0 -> ((RabbitConnectionFactoryBean)factory).setMaxInboundMessageBodySize(arg_0));
    }

    private static void applySslBundle(RabbitConnectionFactoryBean factory, SslBundle bundle) {
        factory.setUseSSL(true);
        if (factory instanceof SslBundleRabbitConnectionFactoryBean) {
            SslBundleRabbitConnectionFactoryBean sslFactory = (SslBundleRabbitConnectionFactoryBean)factory;
            sslFactory.setSslBundle(bundle);
        }
    }
}

