/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.amqp.autoconfigure;

import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.amqp.autoconfigure.RabbitConnectionDetails;
import org.springframework.boot.amqp.autoconfigure.RabbitProperties;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class PropertiesRabbitConnectionDetails
implements RabbitConnectionDetails {
    private final RabbitProperties properties;
    private final SslBundles sslBundles;

    PropertiesRabbitConnectionDetails(RabbitProperties properties, SslBundles sslBundles) {
        this.properties = properties;
        this.sslBundles = sslBundles;
    }

    @Override
    public String getUsername() {
        return this.properties.determineUsername();
    }

    @Override
    public String getPassword() {
        return this.properties.determinePassword();
    }

    @Override
    public String getVirtualHost() {
        return this.properties.determineVirtualHost();
    }

    @Override
    public List<RabbitConnectionDetails.Address> getAddresses() {
        ArrayList<RabbitConnectionDetails.Address> addresses = new ArrayList<RabbitConnectionDetails.Address>();
        for (String address : this.properties.determineAddresses()) {
            int portSeparatorIndex = address.lastIndexOf(58);
            String host = address.substring(0, portSeparatorIndex);
            String port = address.substring(portSeparatorIndex + 1);
            addresses.add(new RabbitConnectionDetails.Address(host, Integer.parseInt(port)));
        }
        return addresses;
    }

    @Override
    public SslBundle getSslBundle() {
        RabbitProperties.Ssl ssl = this.properties.getSsl();
        if (!ssl.determineEnabled()) {
            return null;
        }
        if (StringUtils.hasLength((String)ssl.getBundle())) {
            Assert.notNull((Object)this.sslBundles, (String)"SSL bundle name has been set but no SSL bundles found in context");
            return this.sslBundles.getBundle(ssl.getBundle());
        }
        return null;
    }
}

