/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.activemq.docker.compose;

import org.springframework.boot.activemq.autoconfigure.ActiveMQConnectionDetails;
import org.springframework.boot.activemq.docker.compose.ActiveMQClassicEnvironment;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;

class ActiveMQClassicDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<ActiveMQConnectionDetails> {
    private static final int ACTIVEMQ_PORT = 61616;

    protected ActiveMQClassicDockerComposeConnectionDetailsFactory() {
        super("apache/activemq-classic", new String[0]);
    }

    protected ActiveMQConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new ActiveMQDockerComposeConnectionDetails(source.getRunningService());
    }

    static class ActiveMQDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements ActiveMQConnectionDetails {
        private final ActiveMQClassicEnvironment environment;
        private final String brokerUrl;

        protected ActiveMQDockerComposeConnectionDetails(RunningService service) {
            super(service);
            this.environment = new ActiveMQClassicEnvironment(service.env());
            this.brokerUrl = "tcp://" + service.host() + ":" + service.ports().get(61616);
        }

        @Override
        public String getBrokerUrl() {
            return this.brokerUrl;
        }

        @Override
        public String getUser() {
            return this.environment.getUser();
        }

        @Override
        public String getPassword() {
            return this.environment.getPassword();
        }
    }
}

