/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.experimental.maven;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.springframework.boot.loader.tools.JavaExecutable;
import org.springframework.boot.loader.tools.RunProcess;

public abstract class ThinJarMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    protected Settings settings;
    @Parameter(property="skip", defaultValue="false")
    protected boolean skip;
    @Parameter(defaultValue="org.springframework.boot.experimental:spring-boot-thin-launcher:1.0.31.RELEASE:jar:exec", required=true, property="thin.launcherArtifact")
    private String thinLauncherArtifact;
    @Component
    private RepositorySystem repositorySystem;
    private static final int EXIT_CODE_SIGINT = 130;

    protected File resolveFile(Dependency deployable) {
        Artifact artifact = this.repositorySystem.createArtifactWithClassifier(deployable.getGroupId(), deployable.getArtifactId(), deployable.getVersion(), deployable.getType(), deployable.getClassifier());
        artifact = (Artifact)this.repositorySystem.resolve(this.getRequest(artifact)).getArtifacts().iterator().next();
        return artifact.getFile();
    }

    protected void runWithForkedJvm(File archive, File workingDirectory, String ... args) throws MojoExecutionException {
        try {
            String localRepo = this.settings.getLocalRepository();
            String thinRepo = this.getThinRepo();
            String debug = this.getProperty("thin.debug");
            ArrayList<String> cmd = new ArrayList<String>(Arrays.asList(new JavaExecutable().toString(), "-Dthin.dryrun", "-Dthin.root=.", "-jar", archive.getAbsolutePath()));
            if (localRepo != null) {
                this.getLog().debug((CharSequence)("Local repo: " + localRepo));
                cmd.add(1, "-Dmaven.repo.local=" + localRepo);
            }
            if (debug != null && !"false".equals(debug)) {
                cmd.add(1, "-Dthin.debug=true");
            }
            if (thinRepo != null) {
                this.getLog().debug((CharSequence)("Thin repo: " + thinRepo));
                cmd.add(1, "-Dthin.repo=" + thinRepo);
            }
            RunProcess runProcess = new RunProcess(workingDirectory, cmd.toArray(new String[0]));
            Runtime.getRuntime().addShutdownHook(new Thread(new RunProcessKiller(runProcess)));
            this.getLog().debug((CharSequence)("Running: " + archive));
            int exitCode = runProcess.run(true, args);
            if (exitCode == 0 || exitCode == 130) {
                return;
            }
            throw new MojoExecutionException("Application finished with exit code: " + exitCode);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Could not exec java", ex);
        }
    }

    private String getThinRepo() {
        String repo = this.getProperty("thin.repo");
        if (repo != null) {
            return repo;
        }
        for (Mirror mirror : this.settings.getMirrors()) {
            String of = mirror.getMirrorOf();
            if (!"*".equals(of) && !"central".equals(of) && (of == null || !of.contains("spring"))) continue;
            return mirror.getUrl();
        }
        return null;
    }

    private String getProperty(String key) {
        if (System.getProperty(key) != null) {
            return System.getProperty(key);
        }
        String KEY = key.replace(".", "_").toUpperCase();
        if (System.getenv(KEY) != null) {
            return System.getProperty(KEY);
        }
        Properties properties = this.project.getProperties();
        if (properties != null && properties.get(key) != null) {
            return properties.getProperty(key);
        }
        return null;
    }

    private ArtifactResolutionRequest getRequest(Artifact artifact) {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(artifact);
        request.setResolveTransitively(false);
        request.setRemoteRepositories(this.project.getRemoteArtifactRepositories());
        return request;
    }

    protected File downloadThinJar(File outputDirectory) throws MojoFailureException {
        Dependency deployable = this.decode(this.thinLauncherArtifact);
        File result = this.resolveFile(deployable);
        try {
            if (!result.getCanonicalFile().toPath().startsWith(outputDirectory.getCanonicalFile().toPath())) {
                String root = new File(this.settings.getLocalRepository()).getCanonicalPath();
                String path = result.getCanonicalPath().substring(root.length());
                File target = new File(new File(outputDirectory, "repository"), path);
                FileUtils.copyFile((File)result, (File)target);
                result = target;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not copy thin jar launcher", e);
        }
        return result;
    }

    private Dependency decode(String artifact) throws MojoFailureException {
        String[] tokens = StringUtils.split((String)artifact, (String)":");
        if (tokens.length < 3 || tokens.length > 5) {
            throw new MojoFailureException("Invalid artifact, you must specify groupId:artifactId:version[:packaging[:classifier]] " + artifact);
        }
        Dependency dependency = new Dependency();
        dependency.setGroupId(tokens[0]);
        dependency.setArtifactId(tokens[1]);
        if (tokens.length >= 4) {
            dependency.setType(tokens[3]);
        }
        if (tokens.length == 5) {
            dependency.setClassifier(tokens[4]);
        }
        dependency.setVersion(tokens[2]);
        return dependency;
    }

    private static final class RunProcessKiller
    implements Runnable {
        private final RunProcess runProcess;

        private RunProcessKiller(RunProcess runProcess) {
            this.runProcess = runProcess;
        }

        @Override
        public void run() {
            this.runProcess.kill();
        }
    }
}

