/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.thin;

import hidden.com.google.inject.AbstractModule;
import hidden.com.google.inject.Provides;
import hidden.com.google.inject.name.Named;
import hidden.com.google.inject.name.Names;
import hidden.org.apache.maven.model.building.ModelProcessor;
import hidden.org.apache.maven.model.io.DefaultModelReader;
import hidden.org.apache.maven.model.io.ModelReader;
import hidden.org.apache.maven.model.locator.DefaultModelLocator;
import hidden.org.apache.maven.model.locator.ModelLocator;
import hidden.org.apache.maven.model.validation.DefaultModelValidator;
import hidden.org.apache.maven.model.validation.ModelValidator;
import hidden.org.apache.maven.repository.internal.DefaultArtifactDescriptorReader;
import hidden.org.apache.maven.repository.internal.DefaultVersionRangeResolver;
import hidden.org.apache.maven.repository.internal.DefaultVersionResolver;
import hidden.org.apache.maven.repository.internal.SnapshotMetadataGeneratorFactory;
import hidden.org.apache.maven.repository.internal.VersionsMetadataGeneratorFactory;
import hidden.org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import hidden.org.eclipse.aether.impl.ArtifactDescriptorReader;
import hidden.org.eclipse.aether.impl.MetadataGeneratorFactory;
import hidden.org.eclipse.aether.impl.VersionRangeResolver;
import hidden.org.eclipse.aether.impl.VersionResolver;
import hidden.org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import hidden.org.eclipse.aether.spi.connector.transport.TransporterFactory;
import hidden.org.eclipse.aether.transport.file.FileTransporterFactory;
import hidden.org.eclipse.aether.transport.http.HttpTransporterFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Singleton;
import org.springframework.boot.loader.thin.ThinPropertiesModelProcessor;

class DependencyResolutionModule
extends AbstractModule {
    DependencyResolutionModule() {
    }

    @Override
    protected void configure() {
        this.bind(ModelProcessor.class).to(ThinPropertiesModelProcessor.class).in(Singleton.class);
        this.bind(ModelLocator.class).to(DefaultModelLocator.class).in(Singleton.class);
        this.bind(ModelReader.class).to(DefaultModelReader.class).in(Singleton.class);
        this.bind(ModelValidator.class).to(DefaultModelValidator.class).in(Singleton.class);
        this.bind(RepositoryConnectorFactory.class).to(BasicRepositoryConnectorFactory.class).in(Singleton.class);
        this.bind(ArtifactDescriptorReader.class).to(DefaultArtifactDescriptorReader.class).in(Singleton.class);
        this.bind(VersionResolver.class).to(DefaultVersionResolver.class).in(Singleton.class);
        this.bind(VersionRangeResolver.class).to(DefaultVersionRangeResolver.class).in(Singleton.class);
        this.bind(MetadataGeneratorFactory.class).annotatedWith(Names.named("snapshot")).to(SnapshotMetadataGeneratorFactory.class).in(Singleton.class);
        this.bind(MetadataGeneratorFactory.class).annotatedWith(Names.named("versions")).to(VersionsMetadataGeneratorFactory.class).in(Singleton.class);
        this.bind(TransporterFactory.class).annotatedWith(Names.named("http")).to(HttpTransporterFactory.class).in(Singleton.class);
        this.bind(TransporterFactory.class).annotatedWith(Names.named("file")).to(FileTransporterFactory.class).in(Singleton.class);
    }

    @Provides
    @Singleton
    Set<MetadataGeneratorFactory> provideMetadataGeneratorFactories(@Named(value="snapshot") MetadataGeneratorFactory snapshot, @Named(value="versions") MetadataGeneratorFactory versions) {
        HashSet<MetadataGeneratorFactory> factories = new HashSet<MetadataGeneratorFactory>();
        factories.add(snapshot);
        factories.add(versions);
        return Collections.unmodifiableSet(factories);
    }

    @Provides
    @Singleton
    Set<RepositoryConnectorFactory> provideRepositoryConnectorFactories(RepositoryConnectorFactory factory) {
        return Collections.singleton(factory);
    }

    @Provides
    @Singleton
    Set<TransporterFactory> provideTransporterFactories(@Named(value="file") TransporterFactory file, @Named(value="http") TransporterFactory http) {
        HashSet<TransporterFactory> factories = new HashSet<TransporterFactory>();
        factories.add(file);
        factories.add(http);
        return Collections.unmodifiableSet(factories);
    }
}

