/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.eclipse.sisu.space;

import hidden.org.eclipse.sisu.inject.DeferredClass;
import hidden.org.eclipse.sisu.space.ClassSpace;
import hidden.org.eclipse.sisu.space.FileEntryIterator;
import hidden.org.eclipse.sisu.space.NamedClass;
import hidden.org.eclipse.sisu.space.ResourceEnumeration;
import hidden.org.eclipse.sisu.space.Streams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class URLClassSpace
implements ClassSpace {
    private static final String MANIFEST_ENTRY = "META-INF/MANIFEST.MF";
    private static final URL[] NO_URLS;
    private static final Enumeration<URL> NO_ENTRIES;
    private static final String[] EMPTY_CLASSPATH;
    private static final ClassLoader SYSTEM_LOADER;
    private static final String SYSTEM_CLASSPATH;
    private final ClassLoader loader;
    private final String pathDetails;
    private URL[] classPath;

    static {
        String classPath;
        ClassLoader systemLoader;
        try {
            systemLoader = ClassLoader.getSystemClassLoader();
            classPath = System.getProperty("java.class.path", ".");
        }
        catch (RuntimeException runtimeException) {
            systemLoader = null;
            classPath = null;
        }
        catch (LinkageError linkageError) {
            systemLoader = null;
            classPath = null;
        }
        SYSTEM_LOADER = systemLoader;
        SYSTEM_CLASSPATH = classPath;
        NO_URLS = new URL[0];
        NO_ENTRIES = Collections.enumeration(Collections.emptySet());
        EMPTY_CLASSPATH = new String[0];
    }

    public URLClassSpace(ClassLoader loader) {
        this.loader = loader;
        this.pathDetails = null;
    }

    public URLClassSpace(ClassLoader loader, URL[] path) {
        this.loader = loader;
        this.pathDetails = Arrays.toString(path);
        this.classPath = path != null && path.length > 0 ? URLClassSpace.expandClassPath(path) : NO_URLS;
    }

    @Override
    public final Class<?> loadClass(String name) {
        try {
            return this.loader.loadClass(name);
        }
        catch (Exception e) {
            throw new TypeNotPresentException(name, e);
        }
        catch (LinkageError e) {
            throw new TypeNotPresentException(name, e);
        }
    }

    @Override
    public final DeferredClass<?> deferLoadClass(String name) {
        return new NamedClass(this, name);
    }

    @Override
    public final URL getResource(String name) {
        return this.loader.getResource(name);
    }

    @Override
    public final Enumeration<URL> getResources(String name) {
        try {
            Enumeration<URL> resources = this.loader.getResources(name);
            return resources != null ? resources : NO_ENTRIES;
        }
        catch (IOException iOException) {
            return NO_ENTRIES;
        }
    }

    @Override
    public final Enumeration<URL> findEntries(String path, String glob, boolean recurse) {
        if (SYSTEM_LOADER != null && this.loader == SYSTEM_LOADER && this.pathDetails == null && !recurse && glob != null && glob.indexOf(42) < 0) {
            return this.getResources(String.valueOf(ResourceEnumeration.normalizeSearchPath(path)) + glob);
        }
        return new ResourceEnumeration(path, glob, recurse, this.getClassPath());
    }

    public final URL[] getURLs() {
        return (URL[])this.getClassPath().clone();
    }

    public final int hashCode() {
        return this.loader.hashCode();
    }

    public final boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (rhs instanceof URLClassSpace) {
            return this.loader.equals(((URLClassSpace)rhs).loader);
        }
        return false;
    }

    public final String toString() {
        return this.pathDetails == null ? this.loader.toString() : this.loader + "(" + this.pathDetails + ")";
    }

    private synchronized URL[] getClassPath() {
        if (this.classPath == null) {
            ClassLoader l = this.loader;
            while (l != null) {
                if (l instanceof URLClassLoader) {
                    URL[] path = ((URLClassLoader)l).getURLs();
                    if (path != null && path.length > 0) {
                        this.classPath = URLClassSpace.expandClassPath(path);
                        break;
                    }
                } else if (SYSTEM_LOADER != null && l == SYSTEM_LOADER) {
                    this.classPath = URLClassSpace.expandClassPath(URLClassSpace.getSystemClassPath());
                    break;
                }
                l = l.getParent();
            }
            if (this.classPath == null) {
                this.classPath = NO_URLS;
            }
        }
        return this.classPath;
    }

    private static URL[] getSystemClassPath() {
        String[] paths = SYSTEM_CLASSPATH.split(File.pathSeparator);
        URL[] urls = new URL[paths.length];
        int i = 0;
        while (i < paths.length) {
            try {
                urls[i] = new File(paths[i]).toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                urls[i] = null;
            }
            ++i;
        }
        return urls;
    }

    private static URL[] expandClassPath(URL[] classPath) {
        ArrayList<URL> searchPath = new ArrayList<URL>();
        Collections.addAll(searchPath, classPath);
        ArrayList<URL> expandedPath = new ArrayList<URL>();
        HashSet<String> visited = new HashSet<String>();
        int i = 0;
        while (i < searchPath.size()) {
            block7: {
                URL url = URLClassSpace.normalizeEntry((URL)searchPath.get(i));
                if (url != null && visited.add(url.toString())) {
                    String[] classPathEntries;
                    expandedPath.add(url);
                    try {
                        classPathEntries = URLClassSpace.getClassPathEntries(url);
                    }
                    catch (IOException iOException) {
                        break block7;
                    }
                    String[] stringArray = classPathEntries;
                    int n = classPathEntries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String entry = stringArray[n2];
                        try {
                            searchPath.add(new URL(url, entry));
                        }
                        catch (MalformedURLException malformedURLException) {}
                        ++n2;
                    }
                }
            }
            ++i;
        }
        return expandedPath.toArray(new URL[expandedPath.size()]);
    }

    private static URL normalizeEntry(URL url) {
        String path;
        if (url != null && "jar".equals(url.getProtocol()) && (path = url.getPath()).endsWith("!/")) {
            try {
                return new URL(path.substring(0, path.length() - 2));
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e.toString());
            }
        }
        return url;
    }

    private static String[] getClassPathEntries(URL url) throws IOException {
        String classPath;
        Manifest manifest;
        if (url.getPath().endsWith("/")) {
            InputStream in = Streams.open(new URL(url, MANIFEST_ENTRY));
            try {
                manifest = new Manifest(in);
            }
            finally {
                in.close();
            }
        }
        if ("file".equals(url.getProtocol())) {
            JarFile jf = new JarFile(FileEntryIterator.toFile(url));
            try {
                manifest = jf.getManifest();
            }
            finally {
                jf.close();
            }
        }
        JarInputStream jin = new JarInputStream(Streams.open(url));
        try {
            manifest = jin.getManifest();
        }
        finally {
            jin.close();
        }
        if (manifest != null && (classPath = manifest.getMainAttributes().getValue("Class-Path")) != null) {
            return classPath.split(" ");
        }
        return EMPTY_CLASSPATH;
    }
}

