/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.eclipse.sisu.plexus;

import hidden.com.google.inject.Binder;
import hidden.com.google.inject.Module;
import hidden.com.google.inject.matcher.Matchers;
import hidden.org.eclipse.sisu.bean.BeanListener;
import hidden.org.eclipse.sisu.bean.BeanManager;
import hidden.org.eclipse.sisu.plexus.PlexusBeanBinder;
import hidden.org.eclipse.sisu.plexus.PlexusBeanModule;
import hidden.org.eclipse.sisu.plexus.PlexusBeanSource;
import java.util.ArrayList;
import java.util.Collection;

public final class PlexusBindingModule
implements Module {
    private final BeanManager manager;
    private final PlexusBeanModule[] modules;

    public PlexusBindingModule(BeanManager manager, PlexusBeanModule ... modules) {
        this.manager = manager;
        this.modules = (PlexusBeanModule[])modules.clone();
    }

    public PlexusBindingModule(BeanManager manager, Collection<? extends PlexusBeanModule> modules) {
        this.manager = manager;
        this.modules = modules.toArray(new PlexusBeanModule[modules.size()]);
    }

    @Override
    public void configure(Binder binder) {
        ArrayList<PlexusBeanSource> sources = new ArrayList<PlexusBeanSource>(this.modules.length);
        PlexusBeanModule[] plexusBeanModuleArray = this.modules;
        int n = this.modules.length;
        int n2 = 0;
        while (n2 < n) {
            PlexusBeanModule module = plexusBeanModuleArray[n2];
            PlexusBeanSource source = module.configure(binder);
            if (source != null) {
                sources.add(source);
            }
            ++n2;
        }
        PlexusBeanBinder plexusBinder = new PlexusBeanBinder(this.manager, sources);
        binder.bindListener(Matchers.any(), new BeanListener(plexusBinder));
        if (this.manager instanceof Module) {
            ((Module)((Object)this.manager)).configure(binder);
        }
    }
}

