/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.eclipse.sisu.bean;

import java.lang.reflect.Member;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class DeclaredMembers
implements Iterable<Member> {
    private final Class<?> clazz;
    private final View[] views;

    public DeclaredMembers(Class<?> clazz, View ... views) {
        this.clazz = clazz;
        this.views = views.length == 0 ? View.values() : views;
    }

    @Override
    public Iterator<Member> iterator() {
        return new MemberIterator(this.clazz, this.views);
    }

    private static final class MemberIterator
    implements Iterator<Member> {
        private static final Member[] NO_MEMBERS = new Member[0];
        private Class<?> clazz;
        private final View[] views;
        private int viewIndex;
        private Member[] members = NO_MEMBERS;
        private int memberIndex;

        MemberIterator(Class<?> clazz, View[] views) {
            this.clazz = clazz;
            this.views = views;
        }

        @Override
        public boolean hasNext() {
            while (this.memberIndex <= 0) {
                int index;
                if (this.viewIndex >= this.views.length) {
                    this.clazz = this.clazz.getSuperclass();
                    this.viewIndex = 0;
                }
                if (this.clazz == null || this.clazz == Object.class) {
                    return false;
                }
                ++this.viewIndex;
                this.members = this.views[index].members(this.clazz);
                this.memberIndex = this.members.length;
            }
            return true;
        }

        @Override
        public Member next() {
            if (this.hasNext()) {
                return this.members[--this.memberIndex];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static enum View {
        CONSTRUCTORS{

            @Override
            Member[] members(Class<?> clazz) {
                return clazz.getDeclaredConstructors();
            }
        }
        ,
        METHODS{

            @Override
            Member[] members(Class<?> clazz) {
                return clazz.getDeclaredMethods();
            }
        }
        ,
        FIELDS{

            @Override
            Member[] members(Class<?> clazz) {
                return clazz.getDeclaredFields();
            }
        };


        abstract Member[] members(Class<?> var1);
    }
}

