/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.repository.internal;

import hidden.org.apache.maven.model.Repository;
import hidden.org.apache.maven.model.RepositoryPolicy;
import hidden.org.eclipse.aether.artifact.Artifact;
import hidden.org.eclipse.aether.artifact.DefaultArtifact;
import hidden.org.eclipse.aether.repository.RemoteRepository;

public class ArtifactDescriptorUtils {
    public static Artifact toPomArtifact(Artifact artifact) {
        Artifact pomArtifact = artifact;
        if (pomArtifact.getClassifier().length() > 0 || !"pom".equals(pomArtifact.getExtension())) {
            pomArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), "pom", artifact.getVersion());
        }
        return pomArtifact;
    }

    public static RemoteRepository toRemoteRepository(Repository repository) {
        RemoteRepository.Builder builder = new RemoteRepository.Builder(repository.getId(), repository.getLayout(), repository.getUrl());
        builder.setSnapshotPolicy(ArtifactDescriptorUtils.toRepositoryPolicy(repository.getSnapshots()));
        builder.setReleasePolicy(ArtifactDescriptorUtils.toRepositoryPolicy(repository.getReleases()));
        return builder.build();
    }

    public static hidden.org.eclipse.aether.repository.RepositoryPolicy toRepositoryPolicy(RepositoryPolicy policy) {
        boolean enabled = true;
        String checksums = "warn";
        String updates = "daily";
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getUpdatePolicy() != null) {
                updates = policy.getUpdatePolicy();
            }
            if (policy.getChecksumPolicy() != null) {
                checksums = policy.getChecksumPolicy();
            }
        }
        return new hidden.org.eclipse.aether.repository.RepositoryPolicy(enabled, updates, checksums);
    }
}

