/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.lifecycle;

import hidden.org.apache.maven.lifecycle.DefaultLifecycles;
import hidden.org.apache.maven.lifecycle.Lifecycle;
import hidden.org.apache.maven.lifecycle.internal.ExecutionPlanItem;
import hidden.org.apache.maven.model.Plugin;
import hidden.org.apache.maven.plugin.MojoExecution;
import hidden.org.apache.maven.plugin.descriptor.MojoDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MavenExecutionPlan
implements Iterable<ExecutionPlanItem> {
    private final List<ExecutionPlanItem> planItem;
    private final Map<String, ExecutionPlanItem> lastMojoExecutionForAllPhases;
    final List<String> phasesInExecutionPlan;

    /*
     * WARNING - void declaration
     */
    public MavenExecutionPlan(List<ExecutionPlanItem> planItem, DefaultLifecycles defaultLifecycles) {
        this.planItem = planItem;
        this.lastMojoExecutionForAllPhases = new LinkedHashMap<String, ExecutionPlanItem>();
        LinkedHashSet<String> totalPhaseSet = new LinkedHashSet<String>();
        if (defaultLifecycles != null) {
            for (String string : MavenExecutionPlan.getDistinctPhasesInOrderOfExecutionPlanAppearance(planItem)) {
                Lifecycle lifecycle = defaultLifecycles.get(string);
                if (lifecycle == null) continue;
                totalPhaseSet.addAll(lifecycle.getPhases());
            }
        }
        this.phasesInExecutionPlan = new ArrayList<String>(totalPhaseSet);
        HashMap<String, ExecutionPlanItem> lastInExistingPhases = new HashMap<String, ExecutionPlanItem>();
        for (ExecutionPlanItem executionPlanItem : this.getExecutionPlanItems()) {
            lastInExistingPhases.put(executionPlanItem.getLifecyclePhase(), executionPlanItem);
        }
        Object var5_7 = null;
        for (String phase : totalPhaseSet) {
            void var5_8;
            ExecutionPlanItem forThisPhase = (ExecutionPlanItem)lastInExistingPhases.get(phase);
            if (forThisPhase != null) {
                ExecutionPlanItem executionPlanItem = forThisPhase;
            }
            this.lastMojoExecutionForAllPhases.put(phase, (ExecutionPlanItem)var5_8);
        }
    }

    @Override
    public Iterator<ExecutionPlanItem> iterator() {
        return this.getExecutionPlanItems().iterator();
    }

    public ExecutionPlanItem findLastInPhase(String requestedPhase) {
        return this.lastMojoExecutionForAllPhases.get(requestedPhase);
    }

    private List<ExecutionPlanItem> getExecutionPlanItems() {
        return this.planItem;
    }

    private static Iterable<String> getDistinctPhasesInOrderOfExecutionPlanAppearance(List<ExecutionPlanItem> planItems) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (ExecutionPlanItem executionPlanItem : planItems) {
            String phase = executionPlanItem.getLifecyclePhase();
            if (result.contains(phase)) continue;
            result.add(phase);
        }
        return result;
    }

    public List<MojoExecution> getMojoExecutions() {
        ArrayList<MojoExecution> result = new ArrayList<MojoExecution>();
        for (ExecutionPlanItem executionPlanItem : this.planItem) {
            result.add(executionPlanItem.getMojoExecution());
        }
        return result;
    }

    public Set<Plugin> getNonThreadSafePlugins() {
        HashSet<Plugin> plugins = new HashSet<Plugin>();
        for (ExecutionPlanItem executionPlanItem : this.planItem) {
            MojoExecution mojoExecution = executionPlanItem.getMojoExecution();
            if (mojoExecution.getMojoDescriptor().isThreadSafe()) continue;
            plugins.add(mojoExecution.getPlugin());
        }
        return plugins;
    }

    public Set<MojoDescriptor> getNonThreadSafeMojos() {
        HashSet<MojoDescriptor> mojos = new HashSet<MojoDescriptor>();
        for (ExecutionPlanItem executionPlanItem : this.planItem) {
            MojoExecution mojoExecution = executionPlanItem.getMojoExecution();
            if (mojoExecution.getMojoDescriptor().isThreadSafe()) continue;
            mojos.add(mojoExecution.getMojoDescriptor());
        }
        return mojos;
    }

    @Deprecated
    public List<MojoExecution> getExecutions() {
        return this.getMojoExecutions();
    }

    public int size() {
        return this.planItem.size();
    }
}

