/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.lifecycle;

import hidden.org.apache.maven.plugin.MojoExecution;
import hidden.org.apache.maven.project.MavenProject;
import hidden.org.apache.maven.shared.utils.logging.MessageBuilder;
import hidden.org.apache.maven.shared.utils.logging.MessageUtils;

public class LifecycleExecutionException
extends Exception {
    private MavenProject project;

    public LifecycleExecutionException(String message) {
        super(message);
    }

    public LifecycleExecutionException(Throwable cause) {
        super(cause);
    }

    public LifecycleExecutionException(String message, Throwable cause) {
        super(message, cause);
    }

    public LifecycleExecutionException(String message, MavenProject project) {
        super(message);
        this.project = project;
    }

    public LifecycleExecutionException(String message, MojoExecution execution, MavenProject project) {
        super(message);
        this.project = project;
    }

    public LifecycleExecutionException(String message, MojoExecution execution, MavenProject project, Throwable cause) {
        super(message, cause);
        this.project = project;
    }

    public LifecycleExecutionException(MojoExecution execution, MavenProject project, Throwable cause) {
        this(LifecycleExecutionException.createMessage(execution, project, cause), execution, project, cause);
    }

    public MavenProject getProject() {
        return this.project;
    }

    private static String createMessage(MojoExecution execution, MavenProject project, Throwable cause) {
        MessageBuilder buffer = MessageUtils.buffer(256);
        buffer.a("Failed to execute goal");
        if (execution != null) {
            buffer.a(Character.valueOf(' '));
            buffer.mojo(execution.getGroupId() + ':' + execution.getArtifactId() + ':' + execution.getVersion() + ':' + execution.getGoal());
            buffer.a(Character.valueOf(' ')).strong('(' + execution.getExecutionId() + ')');
        }
        if (project != null) {
            buffer.a(" on project ");
            buffer.project(project.getArtifactId());
        }
        if (cause != null) {
            buffer.a(": ").failure(cause.getMessage());
        }
        return buffer.toString();
    }
}

