/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.artifact.resolver;

import hidden.org.apache.maven.artifact.Artifact;
import hidden.org.apache.maven.artifact.repository.ArtifactRepository;
import hidden.org.apache.maven.artifact.repository.RepositoryCache;
import hidden.org.apache.maven.artifact.repository.RepositoryRequest;
import hidden.org.apache.maven.artifact.resolver.ResolutionListener;
import hidden.org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import hidden.org.apache.maven.settings.Mirror;
import hidden.org.apache.maven.settings.Proxy;
import hidden.org.apache.maven.settings.Server;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArtifactResolutionRequest
implements RepositoryRequest {
    private Artifact artifact;
    private Set<Artifact> artifactDependencies;
    private ArtifactRepository localRepository;
    private List<ArtifactRepository> remoteRepositories;
    private ArtifactFilter collectionFilter;
    private ArtifactFilter resolutionFilter;
    private List<ResolutionListener> listeners = new ArrayList<ResolutionListener>();
    private Map<String, Artifact> managedVersionMap;
    private boolean resolveRoot = true;
    private boolean resolveTransitively = false;
    private boolean offline;
    private boolean forceUpdate;
    private List<Server> servers;
    private List<Mirror> mirrors;
    private List<Proxy> proxies;

    public ArtifactResolutionRequest() {
    }

    public ArtifactResolutionRequest(RepositoryRequest request) {
        this.setLocalRepository(request.getLocalRepository());
        this.setRemoteRepositories((List)request.getRemoteRepositories());
        this.setOffline(request.isOffline());
        this.setForceUpdate(request.isForceUpdate());
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public ArtifactResolutionRequest setArtifact(Artifact artifact) {
        this.artifact = artifact;
        return this;
    }

    public ArtifactResolutionRequest setArtifactDependencies(Set<Artifact> artifactDependencies) {
        this.artifactDependencies = artifactDependencies;
        return this;
    }

    public Set<Artifact> getArtifactDependencies() {
        return this.artifactDependencies;
    }

    @Override
    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    @Override
    public ArtifactResolutionRequest setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
        return this;
    }

    @Override
    public List<ArtifactRepository> getRemoteRepositories() {
        return this.remoteRepositories;
    }

    @Override
    public ArtifactResolutionRequest setRemoteRepositories(List<ArtifactRepository> remoteRepositories) {
        this.remoteRepositories = remoteRepositories;
        return this;
    }

    public ArtifactFilter getCollectionFilter() {
        return this.collectionFilter;
    }

    public ArtifactResolutionRequest setCollectionFilter(ArtifactFilter filter) {
        this.collectionFilter = filter;
        return this;
    }

    public ArtifactFilter getResolutionFilter() {
        return this.resolutionFilter;
    }

    public ArtifactResolutionRequest setResolutionFilter(ArtifactFilter filter) {
        this.resolutionFilter = filter;
        return this;
    }

    public List<ResolutionListener> getListeners() {
        return this.listeners;
    }

    public ArtifactResolutionRequest setListeners(List<ResolutionListener> listeners) {
        this.listeners = listeners;
        return this;
    }

    public ArtifactResolutionRequest addListener(ResolutionListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public Map<String, Artifact> getManagedVersionMap() {
        return this.managedVersionMap;
    }

    public ArtifactResolutionRequest setManagedVersionMap(Map<String, Artifact> managedVersionMap) {
        this.managedVersionMap = managedVersionMap;
        return this;
    }

    public ArtifactResolutionRequest setResolveRoot(boolean resolveRoot) {
        this.resolveRoot = resolveRoot;
        return this;
    }

    public boolean isResolveRoot() {
        return this.resolveRoot;
    }

    public ArtifactResolutionRequest setResolveTransitively(boolean resolveDependencies) {
        this.resolveTransitively = resolveDependencies;
        return this;
    }

    public boolean isResolveTransitively() {
        return this.resolveTransitively;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("REQUEST: ").append("\n").append("artifact: ").append(this.artifact).append("\n").append(this.artifactDependencies).append("\n").append("localRepository: ").append(this.localRepository).append("\n").append("remoteRepositories: ").append(this.remoteRepositories).append("\n");
        return sb.toString();
    }

    @Override
    public boolean isOffline() {
        return this.offline;
    }

    @Override
    public ArtifactResolutionRequest setOffline(boolean offline) {
        this.offline = offline;
        return this;
    }

    @Override
    public boolean isForceUpdate() {
        return this.forceUpdate;
    }

    @Override
    public ArtifactResolutionRequest setForceUpdate(boolean forceUpdate) {
        this.forceUpdate = forceUpdate;
        return this;
    }

    public ArtifactResolutionRequest setServers(List<Server> servers) {
        this.servers = servers;
        return this;
    }

    public List<Server> getServers() {
        if (this.servers == null) {
            this.servers = new ArrayList<Server>();
        }
        return this.servers;
    }

    public ArtifactResolutionRequest setMirrors(List<Mirror> mirrors) {
        this.mirrors = mirrors;
        return this;
    }

    public List<Mirror> getMirrors() {
        if (this.mirrors == null) {
            this.mirrors = new ArrayList<Mirror>();
        }
        return this.mirrors;
    }

    public ArtifactResolutionRequest setProxies(List<Proxy> proxies) {
        this.proxies = proxies;
        return this;
    }

    public List<Proxy> getProxies() {
        if (this.proxies == null) {
            this.proxies = new ArrayList<Proxy>();
        }
        return this.proxies;
    }

    public ArtifactResolutionRequest setCache(RepositoryCache cache) {
        return this;
    }
}

