/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.artifact.repository.layout;

import hidden.org.apache.maven.artifact.Artifact;
import hidden.org.apache.maven.artifact.handler.ArtifactHandler;
import hidden.org.apache.maven.artifact.metadata.ArtifactMetadata;
import hidden.org.apache.maven.artifact.repository.ArtifactRepository;
import hidden.org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=ArtifactRepositoryLayout.class, hint="flat")
public class FlatRepositoryLayout
implements ArtifactRepositoryLayout {
    private static final char ARTIFACT_SEPARATOR = '-';
    private static final char GROUP_SEPARATOR = '.';

    @Override
    public String getId() {
        return "flat";
    }

    @Override
    public String pathOf(Artifact artifact) {
        ArtifactHandler artifactHandler = artifact.getArtifactHandler();
        StringBuilder path = new StringBuilder(128);
        path.append(artifact.getArtifactId()).append('-').append(artifact.getVersion());
        if (artifact.hasClassifier()) {
            path.append('-').append(artifact.getClassifier());
        }
        if (artifactHandler.getExtension() != null && artifactHandler.getExtension().length() > 0) {
            path.append('.').append(artifactHandler.getExtension());
        }
        return path.toString();
    }

    @Override
    public String pathOfLocalRepositoryMetadata(ArtifactMetadata metadata, ArtifactRepository repository) {
        return this.pathOfRepositoryMetadata(metadata.getLocalFilename(repository));
    }

    private String pathOfRepositoryMetadata(String filename) {
        StringBuilder path = new StringBuilder(128);
        path.append(filename);
        return path.toString();
    }

    @Override
    public String pathOfRemoteRepositoryMetadata(ArtifactMetadata metadata) {
        return this.pathOfRepositoryMetadata(metadata.getRemoteFilename());
    }

    public String toString() {
        return this.getId();
    }
}

