/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.eclipse.sisu.plexus;

import hidden.com.google.inject.Binder;
import hidden.com.google.inject.Module;
import hidden.org.eclipse.sisu.Parameters;
import hidden.org.eclipse.sisu.bean.BeanManager;
import hidden.org.eclipse.sisu.inject.DeferredProvider;
import hidden.org.eclipse.sisu.plexus.DefaultPlexusBeanLocator;
import hidden.org.eclipse.sisu.plexus.PlexusAnnotatedBeanModule;
import hidden.org.eclipse.sisu.plexus.PlexusBeanConverter;
import hidden.org.eclipse.sisu.plexus.PlexusBeanLocator;
import hidden.org.eclipse.sisu.plexus.PlexusBeanModule;
import hidden.org.eclipse.sisu.plexus.PlexusBindingModule;
import hidden.org.eclipse.sisu.plexus.PlexusLifecycleManager;
import hidden.org.eclipse.sisu.plexus.PlexusXmlBeanConverter;
import hidden.org.eclipse.sisu.plexus.PlexusXmlBeanModule;
import hidden.org.eclipse.sisu.plexus.PseudoPlexusContainer;
import hidden.org.eclipse.sisu.space.BeanScanning;
import hidden.org.eclipse.sisu.space.ClassSpace;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextMapAdapter;
import org.codehaus.plexus.context.DefaultContext;
import org.codehaus.plexus.logging.LoggerManager;

public final class PlexusSpaceModule
implements Module {
    private final ClassSpace space;
    private final BeanScanning scanning;
    private BeanManager delegate;

    public PlexusSpaceModule(ClassSpace space) {
        this(space, BeanScanning.OFF);
    }

    public PlexusSpaceModule(ClassSpace space, BeanScanning scanning) {
        this.space = space;
        this.scanning = scanning;
    }

    @Override
    public void configure(Binder binder) {
        ParameterizedContext context = new ParameterizedContext();
        binder.bind(Context.class).toInstance(context);
        DeferredProvider<?> slf4jLoggerFactoryProvider = this.space.deferLoadClass("hidden.org.slf4j.ILoggerFactory").asProvider();
        binder.requestInjection(slf4jLoggerFactoryProvider);
        binder.bind(PlexusBeanConverter.class).to(PlexusXmlBeanConverter.class);
        binder.bind(PlexusBeanLocator.class).to(DefaultPlexusBeanLocator.class);
        binder.bind(PlexusContainer.class).to(PseudoPlexusContainer.class);
        BeanManager manager = this.delegate instanceof PlexusLifecycleManager ? this.delegate : new PlexusLifecycleManager(binder.getProvider(Context.class), binder.getProvider(LoggerManager.class), slf4jLoggerFactoryProvider, this.delegate);
        binder.bind(BeanManager.class).toInstance(manager);
        ArrayList<PlexusBeanModule> beanModules = new ArrayList<PlexusBeanModule>();
        ContextMapAdapter variables = new ContextMapAdapter(context);
        beanModules.add(new PlexusXmlBeanModule(this.space, variables));
        beanModules.add(new PlexusAnnotatedBeanModule(this.space, variables, this.scanning));
        binder.install(new PlexusBindingModule(manager, beanModules));
    }

    public PlexusSpaceModule with(BeanManager manager) {
        this.delegate = manager;
        return this;
    }

    static final class ParameterizedContext
    extends DefaultContext {
        ParameterizedContext() {
        }

        @Inject
        protected void setParameters(@Parameters Map parameters, PlexusContainer container) {
            this.contextData.putAll(parameters);
            this.contextData.put("plexus", container);
        }
    }
}

