/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.eclipse.aether.util.filter;

import hidden.org.eclipse.aether.artifact.Artifact;
import hidden.org.eclipse.aether.graph.Dependency;
import hidden.org.eclipse.aether.graph.DependencyFilter;
import hidden.org.eclipse.aether.graph.DependencyNode;
import hidden.org.eclipse.aether.version.InvalidVersionSpecificationException;
import hidden.org.eclipse.aether.version.Version;
import hidden.org.eclipse.aether.version.VersionRange;
import hidden.org.eclipse.aether.version.VersionScheme;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class AbstractPatternDependencyFilter
implements DependencyFilter {
    private final Set<String> patterns = new HashSet<String>();
    private final VersionScheme versionScheme;

    public AbstractPatternDependencyFilter(String ... patterns) {
        this((VersionScheme)null, patterns);
    }

    public AbstractPatternDependencyFilter(VersionScheme versionScheme, String ... patterns) {
        this(versionScheme, patterns == null ? null : Arrays.asList(patterns));
    }

    public AbstractPatternDependencyFilter(Collection<String> patterns) {
        this(null, patterns);
    }

    public AbstractPatternDependencyFilter(VersionScheme versionScheme, Collection<String> patterns) {
        if (patterns != null) {
            this.patterns.addAll(patterns);
        }
        this.versionScheme = versionScheme;
    }

    @Override
    public boolean accept(DependencyNode node, List<DependencyNode> parents) {
        Dependency dependency = node.getDependency();
        if (dependency == null) {
            return true;
        }
        return this.accept(dependency.getArtifact());
    }

    protected boolean accept(Artifact artifact) {
        for (String pattern : this.patterns) {
            boolean matched = this.accept(artifact, pattern);
            if (!matched) continue;
            return true;
        }
        return false;
    }

    private boolean accept(Artifact artifact, String pattern) {
        String[] tokens = new String[]{artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getBaseVersion()};
        String[] patternTokens = pattern.split(":");
        boolean matched = patternTokens.length <= tokens.length;
        for (int i = 0; matched && i < patternTokens.length; ++i) {
            matched = this.matches(tokens[i], patternTokens[i]);
        }
        return matched;
    }

    private boolean matches(String token, String pattern) {
        boolean matches;
        if ("*".equals(pattern) || pattern.length() == 0) {
            matches = true;
        } else if (pattern.startsWith("*") && pattern.endsWith("*")) {
            String contains = pattern.substring(1, pattern.length() - 1);
            matches = token.contains(contains);
        } else if (pattern.startsWith("*")) {
            String suffix = pattern.substring(1, pattern.length());
            matches = token.endsWith(suffix);
        } else if (pattern.endsWith("*")) {
            String prefix = pattern.substring(0, pattern.length() - 1);
            matches = token.startsWith(prefix);
        } else {
            matches = pattern.startsWith("[") || pattern.startsWith("(") ? this.isVersionIncludedInRange(token, pattern) : token.equals(pattern);
        }
        return matches;
    }

    private boolean isVersionIncludedInRange(String version, String range) {
        if (this.versionScheme == null) {
            return false;
        }
        try {
            Version parsedVersion = this.versionScheme.parseVersion(version);
            VersionRange parsedRange = this.versionScheme.parseVersionRange(range);
            return parsedRange.containsVersion(parsedVersion);
        }
        catch (InvalidVersionSpecificationException e) {
            return false;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        AbstractPatternDependencyFilter that = (AbstractPatternDependencyFilter)obj;
        return this.patterns.equals(that.patterns) && (this.versionScheme == null ? that.versionScheme == null : this.versionScheme.equals(that.versionScheme));
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.patterns.hashCode();
        hash = hash * 31 + (this.versionScheme == null ? 0 : this.versionScheme.hashCode());
        return hash;
    }
}

