/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.eclipse.aether.transfer;

import hidden.org.eclipse.aether.RequestTrace;
import java.io.File;

public final class TransferResource {
    private final String repositoryUrl;
    private final String resourceName;
    private final File file;
    private final long startTime;
    private final RequestTrace trace;
    private long contentLength = -1L;
    private long resumeOffset;

    public TransferResource(String repositoryUrl, String resourceName, File file, RequestTrace trace) {
        this.repositoryUrl = repositoryUrl == null || repositoryUrl.length() <= 0 ? "" : (repositoryUrl.endsWith("/") ? repositoryUrl : repositoryUrl + '/');
        this.resourceName = resourceName == null || resourceName.length() <= 0 ? "" : (resourceName.startsWith("/") ? resourceName.substring(1) : resourceName);
        this.file = file;
        this.trace = trace;
        this.startTime = System.currentTimeMillis();
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public File getFile() {
        return this.file;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public TransferResource setContentLength(long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public long getResumeOffset() {
        return this.resumeOffset;
    }

    public TransferResource setResumeOffset(long resumeOffset) {
        if (resumeOffset < 0L) {
            throw new IllegalArgumentException("resume offset cannot be negative");
        }
        this.resumeOffset = resumeOffset;
        return this;
    }

    public long getTransferStartTime() {
        return this.startTime;
    }

    public RequestTrace getTrace() {
        return this.trace;
    }

    public String toString() {
        return this.getRepositoryUrl() + this.getResourceName() + " <> " + this.getFile();
    }
}

