/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.eclipse.aether.internal.impl;

import hidden.org.eclipse.aether.spi.connector.checksum.ChecksumPolicy;
import hidden.org.eclipse.aether.spi.log.Logger;
import hidden.org.eclipse.aether.spi.log.LoggerFactory;
import hidden.org.eclipse.aether.spi.log.NullLoggerFactory;
import hidden.org.eclipse.aether.transfer.ChecksumFailureException;
import hidden.org.eclipse.aether.transfer.TransferResource;

abstract class AbstractChecksumPolicy
implements ChecksumPolicy {
    protected final Logger logger;
    protected final TransferResource resource;

    protected AbstractChecksumPolicy(LoggerFactory loggerFactory, TransferResource resource) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, this.getClass());
        this.resource = resource;
    }

    @Override
    public boolean onChecksumMatch(String algorithm, int kind) {
        return true;
    }

    @Override
    public void onChecksumMismatch(String algorithm, int kind, ChecksumFailureException exception) throws ChecksumFailureException {
        if ((kind & 1) == 0) {
            throw exception;
        }
    }

    @Override
    public void onChecksumError(String algorithm, int kind, ChecksumFailureException exception) throws ChecksumFailureException {
        this.logger.debug("Could not validate " + algorithm + " checksum for " + this.resource.getResourceName(), exception);
    }

    @Override
    public void onNoMoreChecksums() throws ChecksumFailureException {
        throw new ChecksumFailureException("Checksum validation failed, no checksums available");
    }

    @Override
    public void onTransferRetry() {
    }
}

