/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.toolchain;

import hidden.org.apache.maven.execution.MavenSession;
import hidden.org.apache.maven.toolchain.DefaultToolchainManager;
import hidden.org.apache.maven.toolchain.MisconfiguredToolchainException;
import hidden.org.apache.maven.toolchain.ToolchainFactory;
import hidden.org.apache.maven.toolchain.ToolchainManagerPrivate;
import hidden.org.apache.maven.toolchain.ToolchainPrivate;
import hidden.org.apache.maven.toolchain.model.ToolchainModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=ToolchainManagerPrivate.class)
public class DefaultToolchainManagerPrivate
extends DefaultToolchainManager
implements ToolchainManagerPrivate {
    @Override
    public ToolchainPrivate[] getToolchainsForType(String type, MavenSession context) throws MisconfiguredToolchainException {
        ArrayList<ToolchainPrivate> toRet = new ArrayList<ToolchainPrivate>();
        ToolchainFactory fact = (ToolchainFactory)this.factories.get(type);
        if (fact == null) {
            this.logger.error("Missing toolchain factory for type: " + type + ". Possibly caused by misconfigured project.");
        } else {
            ToolchainPrivate tool;
            List<ToolchainModel> availableToolchains = context.getRequest().getToolchains().get(type);
            if (availableToolchains != null) {
                for (ToolchainModel toolchainModel : availableToolchains) {
                    toRet.add(fact.createToolchain(toolchainModel));
                }
            }
            if ((tool = fact.createDefaultToolchain()) != null) {
                toRet.add(tool);
            }
        }
        return toRet.toArray(new ToolchainPrivate[toRet.size()]);
    }

    @Override
    public void storeToolchainToBuildContext(ToolchainPrivate toolchain, MavenSession session) {
        Map<String, Object> context = this.retrieveContext(session);
        context.put(DefaultToolchainManagerPrivate.getStorageKey(toolchain.getType()), toolchain.getModel());
    }
}

