/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.project.inheritance;

import hidden.org.apache.maven.model.Build;
import hidden.org.apache.maven.model.Dependency;
import hidden.org.apache.maven.model.DependencyManagement;
import hidden.org.apache.maven.model.DeploymentRepository;
import hidden.org.apache.maven.model.DistributionManagement;
import hidden.org.apache.maven.model.Extension;
import hidden.org.apache.maven.model.Model;
import hidden.org.apache.maven.model.PluginManagement;
import hidden.org.apache.maven.model.ReportPlugin;
import hidden.org.apache.maven.model.ReportSet;
import hidden.org.apache.maven.model.Reporting;
import hidden.org.apache.maven.model.Resource;
import hidden.org.apache.maven.model.Scm;
import hidden.org.apache.maven.model.Site;
import hidden.org.apache.maven.project.ModelUtils;
import hidden.org.apache.maven.project.inheritance.ModelInheritanceAssembler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Component(role=ModelInheritanceAssembler.class)
public class DefaultModelInheritanceAssembler
implements ModelInheritanceAssembler {
    @Override
    public void assembleBuildInheritance(Build childBuild, Build parentBuild, boolean handleAsInheritance) {
        if (childBuild.getSourceDirectory() == null) {
            childBuild.setSourceDirectory(parentBuild.getSourceDirectory());
        }
        if (childBuild.getScriptSourceDirectory() == null) {
            childBuild.setScriptSourceDirectory(parentBuild.getScriptSourceDirectory());
        }
        if (childBuild.getTestSourceDirectory() == null) {
            childBuild.setTestSourceDirectory(parentBuild.getTestSourceDirectory());
        }
        if (childBuild.getOutputDirectory() == null) {
            childBuild.setOutputDirectory(parentBuild.getOutputDirectory());
        }
        if (childBuild.getTestOutputDirectory() == null) {
            childBuild.setTestOutputDirectory(parentBuild.getTestOutputDirectory());
        }
        DefaultModelInheritanceAssembler.mergeExtensionLists(childBuild, parentBuild);
        if (childBuild.getDirectory() == null) {
            childBuild.setDirectory(parentBuild.getDirectory());
        }
        if (childBuild.getDefaultGoal() == null) {
            childBuild.setDefaultGoal(parentBuild.getDefaultGoal());
        }
        if (childBuild.getFinalName() == null) {
            childBuild.setFinalName(parentBuild.getFinalName());
        }
        ModelUtils.mergeFilterLists(childBuild.getFilters(), parentBuild.getFilters());
        List<Resource> resources = childBuild.getResources();
        if (resources == null || resources.isEmpty()) {
            childBuild.setResources(parentBuild.getResources());
        }
        if ((resources = childBuild.getTestResources()) == null || resources.isEmpty()) {
            childBuild.setTestResources(parentBuild.getTestResources());
        }
        ModelUtils.mergePluginLists(childBuild, parentBuild, handleAsInheritance);
        PluginManagement dominantPM = childBuild.getPluginManagement();
        PluginManagement recessivePM = parentBuild.getPluginManagement();
        if (dominantPM == null && recessivePM != null) {
            childBuild.setPluginManagement(recessivePM);
        } else {
            ModelUtils.mergePluginLists(childBuild.getPluginManagement(), parentBuild.getPluginManagement(), false);
        }
    }

    private void assembleScmInheritance(Model child, Model parent, String childPathAdjustment, boolean appendPaths) {
        if (parent.getScm() != null) {
            Scm parentScm = parent.getScm();
            Scm childScm = child.getScm();
            if (childScm == null) {
                childScm = new Scm();
                child.setScm(childScm);
            }
            if (StringUtils.isEmpty(childScm.getConnection()) && !StringUtils.isEmpty(parentScm.getConnection())) {
                childScm.setConnection(this.appendPath(parentScm.getConnection(), child.getArtifactId(), childPathAdjustment, appendPaths));
            }
            if (StringUtils.isEmpty(childScm.getDeveloperConnection()) && !StringUtils.isEmpty(parentScm.getDeveloperConnection())) {
                childScm.setDeveloperConnection(this.appendPath(parentScm.getDeveloperConnection(), child.getArtifactId(), childPathAdjustment, appendPaths));
            }
            if (StringUtils.isEmpty(childScm.getUrl()) && !StringUtils.isEmpty(parentScm.getUrl())) {
                childScm.setUrl(this.appendPath(parentScm.getUrl(), child.getArtifactId(), childPathAdjustment, appendPaths));
            }
        }
    }

    @Override
    public void copyModel(Model dest, Model source) {
        this.assembleModelInheritance(dest, source, null, false);
    }

    @Override
    public void assembleModelInheritance(Model child, Model parent, String childPathAdjustment) {
        this.assembleModelInheritance(child, parent, childPathAdjustment, true);
    }

    @Override
    public void assembleModelInheritance(Model child, Model parent) {
        this.assembleModelInheritance(child, parent, null, true);
    }

    private void assembleModelInheritance(Model child, Model parent, String childPathAdjustment, boolean appendPaths) {
        if (parent == null) {
            return;
        }
        if (child.getGroupId() == null) {
            child.setGroupId(parent.getGroupId());
        }
        if (child.getVersion() == null && child.getParent() != null) {
            child.setVersion(child.getParent().getVersion());
        }
        if (child.getInceptionYear() == null) {
            child.setInceptionYear(parent.getInceptionYear());
        }
        if (child.getUrl() == null) {
            if (parent.getUrl() != null) {
                child.setUrl(this.appendPath(parent.getUrl(), child.getArtifactId(), childPathAdjustment, appendPaths));
            } else {
                child.setUrl(parent.getUrl());
            }
        }
        this.assembleDistributionInheritance(child, parent, childPathAdjustment, appendPaths);
        if (child.getIssueManagement() == null) {
            child.setIssueManagement(parent.getIssueManagement());
        }
        if (child.getDescription() == null) {
            child.setDescription(parent.getDescription());
        }
        if (child.getOrganization() == null) {
            child.setOrganization(parent.getOrganization());
        }
        this.assembleScmInheritance(child, parent, childPathAdjustment, appendPaths);
        if (child.getCiManagement() == null) {
            child.setCiManagement(parent.getCiManagement());
        }
        if (child.getDevelopers().size() == 0) {
            child.setDevelopers(parent.getDevelopers());
        }
        if (child.getLicenses().size() == 0) {
            child.setLicenses(parent.getLicenses());
        }
        if (child.getContributors().size() == 0) {
            child.setContributors(parent.getContributors());
        }
        if (child.getMailingLists().size() == 0) {
            child.setMailingLists(parent.getMailingLists());
        }
        this.assembleBuildInheritance(child, parent);
        this.assembleDependencyInheritance(child, parent);
        child.setRepositories(ModelUtils.mergeRepositoryLists(child.getRepositories(), parent.getRepositories()));
        this.assembleReportingInheritance(child, parent);
        this.assembleDependencyManagementInheritance(child, parent);
        Properties props = new Properties();
        props.putAll((Map<?, ?>)parent.getProperties());
        props.putAll((Map<?, ?>)child.getProperties());
        child.setProperties(props);
    }

    private void assembleDependencyManagementInheritance(Model child, Model parent) {
        DependencyManagement parentDepMgmt = parent.getDependencyManagement();
        DependencyManagement childDepMgmt = child.getDependencyManagement();
        if (parentDepMgmt != null) {
            if (childDepMgmt == null) {
                child.setDependencyManagement(parentDepMgmt);
            } else {
                List<Dependency> childDeps = childDepMgmt.getDependencies();
                TreeMap<String, Dependency> mappedChildDeps = new TreeMap<String, Dependency>();
                for (Dependency dep : childDeps) {
                    mappedChildDeps.put(dep.getManagementKey(), dep);
                }
                for (Dependency dep : parentDepMgmt.getDependencies()) {
                    if (mappedChildDeps.containsKey(dep.getManagementKey())) continue;
                    childDepMgmt.addDependency(dep);
                }
            }
        }
    }

    private void assembleReportingInheritance(Model child, Model parent) {
        Reporting childReporting = child.getReporting();
        Reporting parentReporting = parent.getReporting();
        if (parentReporting != null) {
            if (childReporting == null) {
                childReporting = new Reporting();
                child.setReporting(childReporting);
            }
            childReporting.setExcludeDefaults(parentReporting.isExcludeDefaults());
            if (StringUtils.isEmpty(childReporting.getOutputDirectory())) {
                childReporting.setOutputDirectory(parentReporting.getOutputDirectory());
            }
            DefaultModelInheritanceAssembler.mergeReportPluginLists(childReporting, parentReporting, true);
        }
    }

    private static void mergeReportPluginLists(Reporting child, Reporting parent, boolean handleAsInheritance) {
        if (child == null || parent == null) {
            return;
        }
        List<ReportPlugin> parentPlugins = parent.getPlugins();
        if (parentPlugins != null && !parentPlugins.isEmpty()) {
            TreeMap<String, ReportPlugin> assembledPlugins = new TreeMap<String, ReportPlugin>();
            Map<String, ReportPlugin> childPlugins = child.getReportPluginsAsMap();
            for (ReportPlugin parentPlugin : parentPlugins) {
                String parentInherited = parentPlugin.getInherited();
                if (handleAsInheritance && parentInherited != null && !Boolean.valueOf(parentInherited).booleanValue()) continue;
                ReportPlugin assembledPlugin = parentPlugin;
                ReportPlugin childPlugin = childPlugins.get(parentPlugin.getKey());
                if (childPlugin != null) {
                    assembledPlugin = childPlugin;
                    DefaultModelInheritanceAssembler.mergeReportPluginDefinitions(childPlugin, parentPlugin, handleAsInheritance);
                }
                if (handleAsInheritance && parentInherited == null) {
                    assembledPlugin.unsetInheritanceApplied();
                }
                assembledPlugins.put(assembledPlugin.getKey(), assembledPlugin);
            }
            for (ReportPlugin childPlugin : childPlugins.values()) {
                if (assembledPlugins.containsKey(childPlugin.getKey())) continue;
                assembledPlugins.put(childPlugin.getKey(), childPlugin);
            }
            child.setPlugins(new ArrayList<ReportPlugin>(assembledPlugins.values()));
            child.flushReportPluginMap();
        }
    }

    private static void mergeReportSetDefinitions(ReportSet child, ReportSet parent) {
        List<String> parentReports = parent.getReports();
        List<String> childReports = child.getReports();
        ArrayList<String> reports = new ArrayList<String>();
        if (childReports != null && !childReports.isEmpty()) {
            reports.addAll(childReports);
        }
        if (parentReports != null) {
            for (String report : parentReports) {
                if (reports.contains(report)) continue;
                reports.add(report);
            }
        }
        child.setReports(reports);
        Xpp3Dom childConfiguration = (Xpp3Dom)child.getConfiguration();
        Xpp3Dom parentConfiguration = (Xpp3Dom)parent.getConfiguration();
        childConfiguration = Xpp3Dom.mergeXpp3Dom(childConfiguration, parentConfiguration);
        child.setConfiguration(childConfiguration);
    }

    public static void mergeReportPluginDefinitions(ReportPlugin child, ReportPlugin parent, boolean handleAsInheritance) {
        String parentInherited;
        if (child == null || parent == null) {
            return;
        }
        if (child.getVersion() == null && parent.getVersion() != null) {
            child.setVersion(parent.getVersion());
        }
        boolean parentIsInherited = (parentInherited = parent.getInherited()) == null || Boolean.valueOf(parentInherited) != false;
        List<ReportSet> parentReportSets = parent.getReportSets();
        if (parentReportSets != null && !parentReportSets.isEmpty()) {
            TreeMap<String, ReportSet> assembledReportSets = new TreeMap<String, ReportSet>();
            Map<String, ReportSet> childReportSets = child.getReportSetsAsMap();
            Iterator<Object> i$ = parentReportSets.iterator();
            while (i$.hasNext()) {
                ReportSet reportSet;
                ReportSet parentReportSet = reportSet = i$.next();
                if (handleAsInheritance && !parentIsInherited) continue;
                ReportSet assembledReportSet = parentReportSet;
                ReportSet childReportSet = childReportSets.get(parentReportSet.getId());
                if (childReportSet != null) {
                    DefaultModelInheritanceAssembler.mergeReportSetDefinitions(childReportSet, parentReportSet);
                    assembledReportSet = childReportSet;
                } else if (handleAsInheritance && parentInherited == null) {
                    parentReportSet.unsetInheritanceApplied();
                }
                assembledReportSets.put(assembledReportSet.getId(), assembledReportSet);
            }
            for (Map.Entry entry : childReportSets.entrySet()) {
                String id = (String)entry.getKey();
                if (assembledReportSets.containsKey(id)) continue;
                assembledReportSets.put(id, (ReportSet)entry.getValue());
            }
            child.setReportSets(new ArrayList<ReportSet>(assembledReportSets.values()));
            child.flushReportSetMap();
        }
    }

    private void assembleDependencyInheritance(Model child, Model parent) {
        LinkedHashMap<String, Dependency> depsMap = new LinkedHashMap<String, Dependency>();
        List<Dependency> deps = parent.getDependencies();
        if (deps != null) {
            for (Dependency dependency : deps) {
                depsMap.put(dependency.getManagementKey(), dependency);
            }
        }
        if ((deps = child.getDependencies()) != null) {
            for (Dependency dependency : deps) {
                depsMap.put(dependency.getManagementKey(), dependency);
            }
        }
        child.setDependencies(new ArrayList<Dependency>(depsMap.values()));
    }

    private void assembleBuildInheritance(Model child, Model parent) {
        Build childBuild = child.getBuild();
        Build parentBuild = parent.getBuild();
        if (parentBuild != null) {
            if (childBuild == null) {
                childBuild = new Build();
                child.setBuild(childBuild);
            }
            this.assembleBuildInheritance(childBuild, parentBuild, true);
        }
    }

    private void assembleDistributionInheritance(Model child, Model parent, String childPathAdjustment, boolean appendPaths) {
        if (parent.getDistributionManagement() != null) {
            DeploymentRepository repository;
            DistributionManagement parentDistMgmt = parent.getDistributionManagement();
            DistributionManagement childDistMgmt = child.getDistributionManagement();
            if (childDistMgmt == null) {
                childDistMgmt = new DistributionManagement();
                child.setDistributionManagement(childDistMgmt);
            }
            if (childDistMgmt.getSite() == null && parentDistMgmt.getSite() != null) {
                Site site = new Site();
                childDistMgmt.setSite(site);
                site.setId(parentDistMgmt.getSite().getId());
                site.setName(parentDistMgmt.getSite().getName());
                site.setUrl(parentDistMgmt.getSite().getUrl());
                if (site.getUrl() != null) {
                    site.setUrl(this.appendPath(site.getUrl(), child.getArtifactId(), childPathAdjustment, appendPaths));
                }
            }
            if (childDistMgmt.getRepository() == null && parentDistMgmt.getRepository() != null) {
                repository = DefaultModelInheritanceAssembler.copyDistributionRepository(parentDistMgmt.getRepository());
                childDistMgmt.setRepository(repository);
            }
            if (childDistMgmt.getSnapshotRepository() == null && parentDistMgmt.getSnapshotRepository() != null) {
                repository = DefaultModelInheritanceAssembler.copyDistributionRepository(parentDistMgmt.getSnapshotRepository());
                childDistMgmt.setSnapshotRepository(repository);
            }
            if (StringUtils.isEmpty(childDistMgmt.getDownloadUrl())) {
                childDistMgmt.setDownloadUrl(parentDistMgmt.getDownloadUrl());
            }
        }
    }

    private static DeploymentRepository copyDistributionRepository(DeploymentRepository parentRepository) {
        DeploymentRepository repository = new DeploymentRepository();
        repository.setId(parentRepository.getId());
        repository.setName(parentRepository.getName());
        repository.setUrl(parentRepository.getUrl());
        repository.setLayout(parentRepository.getLayout());
        repository.setUniqueVersion(parentRepository.isUniqueVersion());
        return repository;
    }

    protected String appendPath(String parentPath, String childPath, String pathAdjustment, boolean appendPaths) {
        String uncleanPath = parentPath;
        if (appendPaths) {
            if (pathAdjustment != null) {
                uncleanPath = uncleanPath + "/" + pathAdjustment;
            }
            if (childPath != null) {
                uncleanPath = uncleanPath + "/" + childPath;
            }
        }
        String cleanedPath = "";
        int protocolIdx = uncleanPath.indexOf("://");
        if (protocolIdx > -1) {
            cleanedPath = uncleanPath.substring(0, protocolIdx + 3);
            uncleanPath = uncleanPath.substring(protocolIdx + 3);
        }
        if (uncleanPath.startsWith("/")) {
            cleanedPath = cleanedPath + "/";
        }
        return cleanedPath + DefaultModelInheritanceAssembler.resolvePath(uncleanPath);
    }

    private static String resolvePath(String uncleanPath) {
        LinkedList<String> pathElements = new LinkedList<String>();
        StringTokenizer tokenizer = new StringTokenizer(uncleanPath, "/");
        while (tokenizer.hasMoreTokens()) {
            String token;
            switch (token = tokenizer.nextToken()) {
                case "": {
                    break;
                }
                case "..": {
                    if (pathElements.isEmpty()) break;
                    pathElements.removeLast();
                    break;
                }
                default: {
                    pathElements.addLast(token);
                }
            }
        }
        StringBuilder cleanedPath = new StringBuilder();
        while (!pathElements.isEmpty()) {
            cleanedPath.append((String)pathElements.removeFirst());
            if (pathElements.isEmpty()) continue;
            cleanedPath.append('/');
        }
        return cleanedPath.toString();
    }

    private static void mergeExtensionLists(Build childBuild, Build parentBuild) {
        for (Extension e : parentBuild.getExtensions()) {
            if (childBuild.getExtensions().contains(e)) continue;
            childBuild.addExtension(e);
        }
    }
}

