/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.plugin;

import hidden.org.apache.maven.artifact.Artifact;
import hidden.org.apache.maven.model.Plugin;
import hidden.org.apache.maven.plugin.CacheUtils;
import hidden.org.apache.maven.plugin.PluginRealmCache;
import hidden.org.apache.maven.project.MavenProject;
import hidden.org.eclipse.aether.RepositorySystemSession;
import hidden.org.eclipse.aether.graph.DependencyFilter;
import hidden.org.eclipse.aether.repository.LocalRepository;
import hidden.org.eclipse.aether.repository.RemoteRepository;
import hidden.org.eclipse.aether.repository.WorkspaceRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.Validate;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;

@Component(role=PluginRealmCache.class)
public class DefaultPluginRealmCache
implements PluginRealmCache,
Disposable {
    protected final Map<PluginRealmCache.Key, PluginRealmCache.CacheRecord> cache = new ConcurrentHashMap<PluginRealmCache.Key, PluginRealmCache.CacheRecord>();

    @Override
    public PluginRealmCache.Key createKey(Plugin plugin, ClassLoader parentRealm, Map<String, ClassLoader> foreignImports, DependencyFilter dependencyFilter, List<RemoteRepository> repositories, RepositorySystemSession session) {
        return new CacheKey(plugin, parentRealm, foreignImports, dependencyFilter, repositories, session);
    }

    @Override
    public PluginRealmCache.CacheRecord get(PluginRealmCache.Key key) {
        return this.cache.get(key);
    }

    @Override
    public PluginRealmCache.CacheRecord put(PluginRealmCache.Key key, ClassRealm pluginRealm, List<Artifact> pluginArtifacts) {
        Validate.notNull(pluginRealm, "pluginRealm cannot be null", new Object[0]);
        Validate.notNull(pluginArtifacts, "pluginArtifacts cannot be null", new Object[0]);
        if (this.cache.containsKey(key)) {
            throw new IllegalStateException("Duplicate plugin realm for plugin " + key);
        }
        PluginRealmCache.CacheRecord record = new PluginRealmCache.CacheRecord(pluginRealm, pluginArtifacts);
        this.cache.put(key, record);
        return record;
    }

    @Override
    public void flush() {
        for (PluginRealmCache.CacheRecord record : this.cache.values()) {
            ClassRealm realm = record.realm;
            try {
                realm.getWorld().disposeRealm(realm.getId());
            }
            catch (NoSuchRealmException noSuchRealmException) {}
        }
        this.cache.clear();
    }

    protected static int pluginHashCode(Plugin plugin) {
        return CacheUtils.pluginHashCode(plugin);
    }

    protected static boolean pluginEquals(Plugin a, Plugin b) {
        return CacheUtils.pluginEquals(a, b);
    }

    @Override
    public void register(MavenProject project, PluginRealmCache.Key key, PluginRealmCache.CacheRecord record) {
    }

    @Override
    public void dispose() {
        this.flush();
    }

    protected static class CacheKey
    implements PluginRealmCache.Key {
        private final Plugin plugin;
        private final WorkspaceRepository workspace;
        private final LocalRepository localRepo;
        private final List<RemoteRepository> repositories;
        private final ClassLoader parentRealm;
        private final Map<String, ClassLoader> foreignImports;
        private final DependencyFilter filter;
        private final int hashCode;

        public CacheKey(Plugin plugin, ClassLoader parentRealm, Map<String, ClassLoader> foreignImports, DependencyFilter dependencyFilter, List<RemoteRepository> repositories, RepositorySystemSession session) {
            this.plugin = plugin.clone();
            this.workspace = CacheUtils.getWorkspace(session);
            this.localRepo = session.getLocalRepository();
            this.repositories = new ArrayList<RemoteRepository>(repositories.size());
            for (RemoteRepository repository : repositories) {
                if (repository.isRepositoryManager()) {
                    this.repositories.addAll(repository.getMirroredRepositories());
                    continue;
                }
                this.repositories.add(repository);
            }
            this.parentRealm = parentRealm;
            this.foreignImports = foreignImports != null ? foreignImports : Collections.emptyMap();
            this.filter = dependencyFilter;
            int hash = 17;
            hash = hash * 31 + CacheUtils.pluginHashCode(plugin);
            hash = hash * 31 + CacheKey.hash(this.workspace);
            hash = hash * 31 + CacheKey.hash(this.localRepo);
            hash = hash * 31 + CacheUtils.repositoriesHashCode(repositories);
            hash = hash * 31 + CacheKey.hash(parentRealm);
            hash = hash * 31 + this.foreignImports.hashCode();
            this.hashCode = hash = hash * 31 + CacheKey.hash(dependencyFilter);
        }

        public String toString() {
            return this.plugin.getId();
        }

        public int hashCode() {
            return this.hashCode;
        }

        private static int hash(Object obj) {
            return obj != null ? obj.hashCode() : 0;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey that = (CacheKey)o;
            return this.parentRealm == that.parentRealm && CacheUtils.pluginEquals(this.plugin, that.plugin) && CacheKey.eq(this.workspace, that.workspace) && CacheKey.eq(this.localRepo, that.localRepo) && CacheUtils.repositoriesEquals(this.repositories, that.repositories) && CacheKey.eq(this.filter, that.filter) && CacheKey.eq(this.foreignImports, that.foreignImports);
        }

        private static <T> boolean eq(T s1, T s2) {
            return s1 != null ? s1.equals(s2) : s2 == null;
        }
    }
}

