/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.cli.logging;

import hidden.org.apache.maven.cli.logging.Slf4jConfiguration;
import hidden.org.apache.maven.cli.logging.impl.UnsupportedSlf4jBindingConfiguration;
import hidden.org.slf4j.ILoggerFactory;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.Set;
import org.codehaus.plexus.util.PropertyUtils;

public class Slf4jConfigurationFactory {
    public static final String RESOURCE = "META-INF/maven/slf4j-configuration.properties";

    public static Slf4jConfiguration getConfiguration(ILoggerFactory loggerFactory) {
        LinkedHashMap<URL, Set<Object>> supported = new LinkedHashMap<URL, Set<Object>>();
        String slf4jBinding = loggerFactory.getClass().getCanonicalName();
        try {
            Enumeration<URL> resources = Slf4jConfigurationFactory.class.getClassLoader().getResources(RESOURCE);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                Properties conf = PropertyUtils.loadProperties(resource.openStream());
                String impl = conf.getProperty(slf4jBinding);
                if (impl != null) {
                    return (Slf4jConfiguration)Class.forName(impl).newInstance();
                }
                supported.put(resource, conf.keySet());
            }
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        return new UnsupportedSlf4jBindingConfiguration(slf4jBinding, supported);
    }
}

