/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven;

import hidden.org.apache.maven.ArtifactFilterManager;
import hidden.org.apache.maven.ArtifactFilterManagerDelegate;
import hidden.org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import hidden.org.apache.maven.artifact.resolver.filter.ExclusionSetFilter;
import hidden.org.apache.maven.extension.internal.CoreExportsProvider;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

@Named
@Singleton
public class DefaultArtifactFilterManager
implements ArtifactFilterManager {
    protected final List<ArtifactFilterManagerDelegate> delegates;
    protected Set<String> excludedArtifacts;
    private final Set<String> coreArtifacts;

    @Inject
    public DefaultArtifactFilterManager(List<ArtifactFilterManagerDelegate> delegates, CoreExportsProvider coreExports) {
        this.delegates = delegates;
        this.coreArtifacts = coreExports.get().getExportedArtifacts();
    }

    private synchronized Set<String> getExcludedArtifacts() {
        if (this.excludedArtifacts == null) {
            this.excludedArtifacts = new LinkedHashSet<String>(this.coreArtifacts);
        }
        return this.excludedArtifacts;
    }

    @Override
    public ArtifactFilter getArtifactFilter() {
        LinkedHashSet<String> excludes = new LinkedHashSet<String>(this.getExcludedArtifacts());
        for (ArtifactFilterManagerDelegate delegate : this.delegates) {
            delegate.addExcludes(excludes);
        }
        return new ExclusionSetFilter(excludes);
    }

    @Override
    public ArtifactFilter getCoreArtifactFilter() {
        return new ExclusionSetFilter(this.getCoreArtifactExcludes());
    }

    @Override
    public void excludeArtifact(String artifactId) {
        this.getExcludedArtifacts().add(artifactId);
    }

    @Override
    public Set<String> getCoreArtifactExcludes() {
        LinkedHashSet<String> excludes = new LinkedHashSet<String>(this.coreArtifacts);
        for (ArtifactFilterManagerDelegate delegate : this.delegates) {
            delegate.addCoreExcludes(excludes);
        }
        return excludes;
    }
}

