/*
 * Decompiled with CFR 0.152.
 */
package hidden.com.google.inject.internal;

import hidden.com.google.common.base.Objects;
import hidden.com.google.inject.Key;
import hidden.com.google.inject.internal.CreationListener;
import hidden.com.google.inject.internal.Errors;
import hidden.com.google.inject.internal.ErrorsException;
import hidden.com.google.inject.internal.InjectorImpl;
import hidden.com.google.inject.internal.InternalContext;
import hidden.com.google.inject.internal.InternalFactory;
import hidden.com.google.inject.spi.Dependency;

final class FactoryProxy<T>
implements InternalFactory<T>,
CreationListener {
    private final InjectorImpl injector;
    private final Key<T> key;
    private final Key<? extends T> targetKey;
    private final Object source;
    private InternalFactory<? extends T> targetFactory;

    FactoryProxy(InjectorImpl injector, Key<T> key, Key<? extends T> targetKey, Object source) {
        this.injector = injector;
        this.key = key;
        this.targetKey = targetKey;
        this.source = source;
    }

    @Override
    public void notify(Errors errors) {
        try {
            this.targetFactory = this.injector.getInternalFactory(this.targetKey, errors.withSource(this.source), InjectorImpl.JitLimitation.NEW_OR_EXISTING_JIT);
        }
        catch (ErrorsException e) {
            errors.merge(e.getErrors());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(Errors errors, InternalContext context, Dependency<?> dependency, boolean linked) throws ErrorsException {
        context.pushState(this.targetKey, this.source);
        try {
            T t = this.targetFactory.get(errors.withSource(this.targetKey), context, dependency, true);
            return t;
        }
        finally {
            context.popState();
        }
    }

    public String toString() {
        return Objects.toStringHelper(FactoryProxy.class).add("key", this.key).add("provider", this.targetFactory).toString();
    }
}

