/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.test;

import java.util.Date;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import javax.batch.operations.JobOperator;
import javax.batch.runtime.BatchRuntime;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.Metric;
import javax.batch.runtime.StepExecution;

public class JsrTestUtils {
    private static JobOperator operator = BatchRuntime.getJobOperator();

    private JsrTestUtils() {
    }

    public static JobExecution runJob(String jobName, Properties properties, long timeout) throws TimeoutException {
        long executionId = operator.start(jobName, properties);
        JobExecution execution = operator.getJobExecution(executionId);
        Date curDate = new Date();
        BatchStatus curBatchStatus = execution.getBatchStatus();
        while (curBatchStatus != BatchStatus.STOPPED && curBatchStatus != BatchStatus.COMPLETED && curBatchStatus != BatchStatus.FAILED) {
            if (new Date().getTime() - curDate.getTime() > timeout) {
                throw new TimeoutException("Job processing did not complete in time");
            }
            execution = operator.getJobExecution(executionId);
            curBatchStatus = execution.getBatchStatus();
        }
        return execution;
    }

    public static JobExecution restartJob(long executionId, Properties properties, long timeout) throws TimeoutException {
        long restartId = operator.restart(executionId, properties);
        JobExecution execution = operator.getJobExecution(restartId);
        Date curDate = new Date();
        BatchStatus curBatchStatus = execution.getBatchStatus();
        while (curBatchStatus != BatchStatus.STOPPED && curBatchStatus != BatchStatus.COMPLETED && curBatchStatus != BatchStatus.FAILED) {
            if (new Date().getTime() - curDate.getTime() > timeout) {
                throw new TimeoutException("Job processing did not complete in time");
            }
            execution = operator.getJobExecution(restartId);
            curBatchStatus = execution.getBatchStatus();
        }
        return execution;
    }

    public static Metric getMetric(StepExecution stepExecution, Metric.MetricType type) {
        Metric[] metrics;
        for (Metric metric : metrics = stepExecution.getMetrics()) {
            if (metric.getType() != type) continue;
            return metric;
        }
        return null;
    }
}

