/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.support;

import org.springframework.batch.infrastructure.item.Chunk;
import org.springframework.batch.infrastructure.item.ItemWriter;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.util.Assert;

public class MessageChannelItemWriter<T>
implements ItemWriter<T> {
    private final MessagingTemplate messagingTemplate;
    private MessageChannel messageChannel;

    public MessageChannelItemWriter(MessagingTemplate messagingGateway) {
        this.messagingTemplate = messagingGateway;
        MessageChannel defaultDestination = (MessageChannel)messagingGateway.getDefaultDestination();
        Assert.notNull((Object)defaultDestination, (String)"MessagingTemplate must have a default destination configured");
        this.messageChannel = defaultDestination;
    }

    public MessageChannelItemWriter(MessagingTemplate messagingTemplate, MessageChannel messageChannel) {
        this.messagingTemplate = messagingTemplate;
        this.messageChannel = messageChannel;
    }

    public void setMessageChannel(MessageChannel messageChannel) {
        this.messageChannel = messageChannel;
    }

    public void write(Chunk<? extends T> items) throws Exception {
        if (!items.isEmpty()) {
            items.forEach(t -> this.messagingTemplate.send((Object)this.messageChannel, (Message)new GenericMessage(t)));
        }
    }
}

