/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.partition;

import org.springframework.batch.core.listener.StepExecutionListener;
import org.springframework.batch.core.partition.PartitionHandler;
import org.springframework.batch.core.partition.Partitioner;
import org.springframework.batch.core.partition.StepExecutionAggregator;
import org.springframework.batch.core.partition.StepExecutionSplitter;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.Step;
import org.springframework.batch.core.step.builder.PartitionStepBuilder;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.core.step.builder.StepBuilderHelper;
import org.springframework.batch.integration.partition.MessageChannelPartitionHandler;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.integration.channel.QueueChannel;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.StandardIntegrationFlow;
import org.springframework.integration.dsl.context.IntegrationFlowContext;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.PollableChannel;
import org.springframework.util.Assert;

public class RemotePartitioningManagerStepBuilder
extends PartitionStepBuilder {
    private static final long DEFAULT_POLL_INTERVAL = 10000L;
    private static final long DEFAULT_TIMEOUT = -1L;
    private MessagingTemplate messagingTemplate;
    private MessageChannel inputChannel;
    private MessageChannel outputChannel;
    private BeanFactory beanFactory;
    private long pollInterval = 10000L;
    private long timeout = -1L;

    public RemotePartitioningManagerStepBuilder(String stepName, JobRepository jobRepository) {
        super((StepBuilderHelper)new StepBuilder(stepName, jobRepository));
    }

    public RemotePartitioningManagerStepBuilder inputChannel(MessageChannel inputChannel) {
        Assert.notNull((Object)inputChannel, (String)"inputChannel must not be null");
        this.inputChannel = inputChannel;
        return this;
    }

    public RemotePartitioningManagerStepBuilder outputChannel(MessageChannel outputChannel) {
        Assert.notNull((Object)outputChannel, (String)"outputChannel must not be null");
        this.outputChannel = outputChannel;
        return this;
    }

    public RemotePartitioningManagerStepBuilder messagingTemplate(MessagingTemplate messagingTemplate) {
        Assert.notNull((Object)messagingTemplate, (String)"messagingTemplate must not be null");
        this.messagingTemplate = messagingTemplate;
        return this;
    }

    public RemotePartitioningManagerStepBuilder pollInterval(long pollInterval) {
        Assert.isTrue((pollInterval > 0L ? 1 : 0) != 0, (String)"The poll interval must be greater than zero");
        this.pollInterval = pollInterval;
        return this;
    }

    public RemotePartitioningManagerStepBuilder timeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public RemotePartitioningManagerStepBuilder beanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        return this;
    }

    public Step build() {
        Assert.state((this.outputChannel == null || this.messagingTemplate == null ? 1 : 0) != 0, (String)"You must specify either an outputChannel or a messagingTemplate but not both.");
        if (this.messagingTemplate == null) {
            this.messagingTemplate = new MessagingTemplate();
            this.messagingTemplate.setDefaultChannel(this.outputChannel);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"No messagingTemplate was provided, using a default one");
            }
        }
        MessageChannelPartitionHandler partitionHandler = new MessageChannelPartitionHandler();
        partitionHandler.setStepName(this.getStepName());
        partitionHandler.setGridSize(this.getGridSize());
        partitionHandler.setMessagingOperations(this.messagingTemplate);
        if (this.isPolling()) {
            partitionHandler.setJobRepository(this.getJobRepository());
            partitionHandler.setPollInterval(this.pollInterval);
            partitionHandler.setTimeout(this.timeout);
        } else {
            QueueChannel replies = new QueueChannel();
            partitionHandler.setReplyChannel((PollableChannel)replies);
            if (this.beanFactory != null) {
                StandardIntegrationFlow standardIntegrationFlow = ((IntegrationFlowBuilder)((IntegrationFlowBuilder)IntegrationFlow.from((MessageChannel)this.inputChannel).aggregate(aggregatorSpec -> aggregatorSpec.processor((Object)partitionHandler))).channel((MessageChannel)replies)).get();
                IntegrationFlowContext integrationFlowContext = (IntegrationFlowContext)this.beanFactory.getBean(IntegrationFlowContext.class);
                integrationFlowContext.registration((IntegrationFlow)standardIntegrationFlow).autoStartup(false).register();
            }
        }
        try {
            partitionHandler.afterPropertiesSet();
            super.partitionHandler((PartitionHandler)partitionHandler);
        }
        catch (Exception e) {
            throw new BeanCreationException("Unable to create a manager step for remote partitioning", (Throwable)e);
        }
        return super.build();
    }

    private boolean isPolling() {
        return this.inputChannel == null;
    }

    public RemotePartitioningManagerStepBuilder partitioner(String workerStepName, Partitioner partitioner) {
        super.partitioner(workerStepName, partitioner);
        return this;
    }

    public RemotePartitioningManagerStepBuilder gridSize(int gridSize) {
        super.gridSize(gridSize);
        return this;
    }

    public RemotePartitioningManagerStepBuilder step(Step step) {
        super.step(step);
        return this;
    }

    public RemotePartitioningManagerStepBuilder splitter(StepExecutionSplitter splitter) {
        super.splitter(splitter);
        return this;
    }

    public RemotePartitioningManagerStepBuilder aggregator(StepExecutionAggregator aggregator) {
        super.aggregator(aggregator);
        return this;
    }

    public RemotePartitioningManagerStepBuilder startLimit(int startLimit) {
        super.startLimit(startLimit);
        return this;
    }

    public RemotePartitioningManagerStepBuilder listener(Object listener) {
        super.listener(listener);
        return this;
    }

    public RemotePartitioningManagerStepBuilder listener(StepExecutionListener listener) {
        super.listener(listener);
        return this;
    }

    public RemotePartitioningManagerStepBuilder allowStartIfComplete(boolean allowStartIfComplete) {
        super.allowStartIfComplete(allowStartIfComplete);
        return this;
    }

    public RemotePartitioningManagerStepBuilder partitionHandler(PartitionHandler partitionHandler) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("When configuring a manager step for remote partitioning using the RemotePartitioningManagerStepBuilder, the partition handler will be automatically set to an instance of MessageChannelPartitionHandler. The partition handler must not be provided in this case.");
    }
}

