/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.async;

import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.infrastructure.item.Chunk;
import org.springframework.batch.infrastructure.item.ExecutionContext;
import org.springframework.batch.infrastructure.item.ItemStream;
import org.springframework.batch.infrastructure.item.ItemStreamException;
import org.springframework.batch.infrastructure.item.ItemStreamWriter;
import org.springframework.batch.infrastructure.item.ItemWriter;
import org.springframework.util.Assert;

public class AsyncItemWriter<T>
implements ItemStreamWriter<Future<T>> {
    private static final Log logger = LogFactory.getLog(AsyncItemWriter.class);
    private ItemWriter<T> delegate;

    public AsyncItemWriter(ItemWriter<T> delegate) {
        Assert.notNull(delegate, (String)"The delegate ItemWriter must not be null");
        this.delegate = delegate;
    }

    public void setDelegate(ItemWriter<T> delegate) {
        this.delegate = delegate;
    }

    public void write(Chunk<? extends Future<T>> items) throws Exception {
        ArrayList list = new ArrayList();
        for (Future future : items) {
            try {
                Object item = future.get();
                if (item == null) continue;
                list.add(item);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof Exception) {
                    Exception exception = (Exception)cause;
                    logger.debug((Object)"An exception was thrown while processing an item", (Throwable)e);
                    throw exception;
                }
                throw e;
            }
        }
        this.delegate.write(new Chunk(list));
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        if (this.delegate instanceof ItemStream) {
            ((ItemStream)this.delegate).open(executionContext);
        }
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        if (this.delegate instanceof ItemStream) {
            ((ItemStream)this.delegate).update(executionContext);
        }
    }

    public void close() throws ItemStreamException {
        if (this.delegate instanceof ItemStream) {
            ((ItemStream)this.delegate).close();
        }
    }
}

