/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.xml.builder;

import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.xml.StaxEventItemWriter;
import org.springframework.batch.infrastructure.item.xml.StaxWriterCallback;
import org.springframework.core.io.WritableResource;
import org.springframework.oxm.Marshaller;
import org.springframework.util.Assert;

public class StaxEventItemWriterBuilder<T> {
    private @Nullable WritableResource resource;
    private @Nullable Marshaller marshaller;
    private @Nullable StaxWriterCallback headerCallback;
    private @Nullable StaxWriterCallback footerCallback;
    private boolean transactional = true;
    private boolean forceSync = false;
    private boolean shouldDeleteIfEmpty = false;
    private String encoding = "UTF-8";
    private String version = "1.0";
    private @Nullable Boolean standalone = StaxEventItemWriter.DEFAULT_STANDALONE_DOCUMENT;
    private String rootTagName = "root";
    private @Nullable Map<String, String> rootElementAttributes;
    private boolean overwriteOutput = true;
    private boolean saveState = true;
    private @Nullable String name;

    public StaxEventItemWriterBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public StaxEventItemWriterBuilder<T> resource(WritableResource resource) {
        this.resource = resource;
        return this;
    }

    public StaxEventItemWriterBuilder<T> marshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
        return this;
    }

    public StaxEventItemWriterBuilder<T> headerCallback(StaxWriterCallback headerCallback) {
        this.headerCallback = headerCallback;
        return this;
    }

    public StaxEventItemWriterBuilder<T> footerCallback(StaxWriterCallback footerCallback) {
        this.footerCallback = footerCallback;
        return this;
    }

    public StaxEventItemWriterBuilder<T> transactional(boolean transactional) {
        this.transactional = transactional;
        return this;
    }

    public StaxEventItemWriterBuilder<T> forceSync(boolean forceSync) {
        this.forceSync = forceSync;
        return this;
    }

    public StaxEventItemWriterBuilder<T> shouldDeleteIfEmpty(boolean shouldDelete) {
        this.shouldDeleteIfEmpty = shouldDelete;
        return this;
    }

    public StaxEventItemWriterBuilder<T> encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public StaxEventItemWriterBuilder<T> version(String version) {
        this.version = version;
        return this;
    }

    public StaxEventItemWriterBuilder<T> standalone(Boolean standalone) {
        this.standalone = standalone;
        return this;
    }

    public StaxEventItemWriterBuilder<T> rootTagName(String rootTagName) {
        this.rootTagName = rootTagName;
        return this;
    }

    public StaxEventItemWriterBuilder<T> rootElementAttributes(Map<String, String> rootElementAttributes) {
        this.rootElementAttributes = rootElementAttributes;
        return this;
    }

    public StaxEventItemWriterBuilder<T> overwriteOutput(boolean overwriteOutput) {
        this.overwriteOutput = overwriteOutput;
        return this;
    }

    public StaxEventItemWriterBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public StaxEventItemWriter<T> build() {
        Assert.notNull((Object)this.marshaller, (String)"A marshaller is required");
        Assert.notNull((Object)this.resource, (String)"A resource is required");
        if (this.saveState) {
            Assert.notNull((Object)this.name, (String)"A name is required");
        }
        StaxEventItemWriter writer = new StaxEventItemWriter(this.resource, this.marshaller);
        writer.setEncoding(this.encoding);
        if (this.footerCallback != null) {
            writer.setFooterCallback(this.footerCallback);
        }
        writer.setForceSync(this.forceSync);
        if (this.headerCallback != null) {
            writer.setHeaderCallback(this.headerCallback);
        }
        writer.setOverwriteOutput(this.overwriteOutput);
        if (this.rootElementAttributes != null) {
            writer.setRootElementAttributes(this.rootElementAttributes);
        }
        writer.setRootTagName(this.rootTagName);
        writer.setSaveState(this.saveState);
        writer.setShouldDeleteIfEmpty(this.shouldDeleteIfEmpty);
        writer.setTransactional(this.transactional);
        writer.setVersion(this.version);
        if (this.name != null) {
            writer.setName(this.name);
        }
        if (this.standalone != null) {
            writer.setStandalone(this.standalone);
        }
        return writer;
    }
}

