/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.xml;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.NonTransientResourceException;
import org.springframework.batch.infrastructure.item.file.ResourceAwareItemReaderItemStream;
import org.springframework.batch.infrastructure.item.support.AbstractItemCountingItemStreamItemReader;
import org.springframework.batch.infrastructure.item.xml.stax.DefaultFragmentEventReader;
import org.springframework.batch.infrastructure.item.xml.stax.FragmentEventReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.oxm.Unmarshaller;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.StaxUtils;

public class StaxEventItemReader<T>
extends AbstractItemCountingItemStreamItemReader<T>
implements ResourceAwareItemReaderItemStream<T>,
InitializingBean {
    private static final Log logger = LogFactory.getLog(StaxEventItemReader.class);
    public static final String DEFAULT_ENCODING = StandardCharsets.UTF_8.name();
    private @Nullable FragmentEventReader fragmentReader;
    private @Nullable XMLEventReader eventReader;
    private Unmarshaller unmarshaller;
    private @Nullable Resource resource;
    private @Nullable InputStream inputStream;
    private final List<QName> fragmentRootElementNames = new ArrayList<QName>();
    private boolean noInput;
    private boolean strict = true;
    private XMLInputFactory xmlInputFactory = StaxUtils.createDefensiveInputFactory();
    private @Nullable String encoding = DEFAULT_ENCODING;

    public StaxEventItemReader(Unmarshaller unmarshaller) {
        Assert.notNull((Object)unmarshaller, (String)"The Unmarshaller must not be null.");
        this.unmarshaller = unmarshaller;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    @Override
    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void setUnmarshaller(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    public void setFragmentRootElementName(String fragmentRootElementName) {
        this.setFragmentRootElementNames(new String[]{fragmentRootElementName});
    }

    public void setFragmentRootElementNames(String[] fragmentRootElementNames) {
        if (!this.fragmentRootElementNames.isEmpty()) {
            this.fragmentRootElementNames.clear();
        }
        for (String fragmentRootElementName : fragmentRootElementNames) {
            this.fragmentRootElementNames.add(this.parseFragmentRootElementName(fragmentRootElementName));
        }
    }

    public void setXmlInputFactory(XMLInputFactory xmlInputFactory) {
        Assert.notNull((Object)xmlInputFactory, (String)"XMLInputFactory must not be null");
        this.xmlInputFactory = xmlInputFactory;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((!this.fragmentRootElementNames.isEmpty() ? 1 : 0) != 0, (String)"The FragmentRootElementNames must not be empty");
        for (QName fragmentRootElementName : this.fragmentRootElementNames) {
            Assert.state((boolean)StringUtils.hasText((String)fragmentRootElementName.getLocalPart()), (String)"The FragmentRootElementNames must not contain empty elements");
        }
    }

    protected boolean moveCursorToNextFragment(XMLEventReader reader) throws NonTransientResourceException {
        try {
            while (true) {
                if (reader.peek() != null && !reader.peek().isStartElement()) {
                    reader.nextEvent();
                    continue;
                }
                if (reader.peek() == null) {
                    return false;
                }
                QName startElementName = ((StartElement)reader.peek()).getName();
                if (this.isFragmentRootElementName(startElementName)) {
                    return true;
                }
                reader.nextEvent();
            }
        }
        catch (XMLStreamException e) {
            throw new NonTransientResourceException("Error while reading from event reader", e);
        }
    }

    @Override
    protected void doClose() throws Exception {
        try {
            if (this.fragmentReader != null) {
                this.fragmentReader.close();
            }
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        finally {
            this.fragmentReader = null;
            this.inputStream = null;
        }
    }

    @Override
    protected void doOpen() throws Exception {
        Assert.notNull((Object)this.resource, (String)"The Resource must not be null.");
        this.noInput = true;
        if (!this.resource.exists()) {
            if (this.strict) {
                throw new IllegalStateException("Input resource " + String.valueOf(this.resource.getURL()) + " must exist (reader is in 'strict' mode)");
            }
            logger.warn((Object)("Input resource does not exist " + this.resource.getDescription()));
            return;
        }
        if (!this.resource.isReadable()) {
            if (this.strict) {
                throw new IllegalStateException("Input resource  " + String.valueOf(this.resource.getURL()) + " must be readable (reader is in 'strict' mode)");
            }
            logger.warn((Object)("Input resource is not readable " + this.resource.getDescription()));
            return;
        }
        this.inputStream = this.resource.getInputStream();
        this.eventReader = this.encoding != null ? this.xmlInputFactory.createXMLEventReader(this.inputStream, this.encoding) : this.xmlInputFactory.createXMLEventReader(this.inputStream);
        this.fragmentReader = new DefaultFragmentEventReader(this.eventReader);
        this.noInput = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected @Nullable T doRead() throws IOException, XMLStreamException {
        boolean success;
        if (this.noInput) {
            return null;
        }
        Object item = null;
        try {
            success = this.moveCursorToNextFragment(this.fragmentReader);
        }
        catch (NonTransientResourceException e) {
            this.noInput = true;
            throw e;
        }
        if (success) {
            this.fragmentReader.markStartFragment();
            try {
                Object mappedFragment;
                item = mappedFragment = this.unmarshaller.unmarshal(StaxUtils.createStaxSource((XMLEventReader)this.fragmentReader));
            }
            finally {
                this.fragmentReader.markFragmentProcessed();
            }
        }
        return (T)item;
    }

    @Override
    protected void jumpToItem(int itemIndex) throws Exception {
        for (int i = 0; i < itemIndex; ++i) {
            try {
                QName fragmentName = this.readToStartFragment();
                this.readToEndFragment(fragmentName);
                continue;
            }
            catch (NoSuchElementException e) {
                if (itemIndex == i + 1) {
                    return;
                }
                throw e;
            }
        }
    }

    private QName readToStartFragment() throws XMLStreamException {
        XMLEvent nextEvent;
        while (!(nextEvent = this.eventReader.nextEvent()).isStartElement() || !this.isFragmentRootElementName(((StartElement)nextEvent).getName())) {
        }
        return ((StartElement)nextEvent).getName();
    }

    private void readToEndFragment(QName fragmentRootElementName) throws XMLStreamException {
        XMLEvent nextEvent;
        while (!(nextEvent = this.eventReader.nextEvent()).isEndElement() || !fragmentRootElementName.equals(((EndElement)nextEvent).getName())) {
        }
    }

    protected boolean isFragmentRootElementName(QName name) {
        for (QName fragmentRootElementName : this.fragmentRootElementNames) {
            if (!fragmentRootElementName.getLocalPart().equals(name.getLocalPart()) || StringUtils.hasText((String)fragmentRootElementName.getNamespaceURI()) && !fragmentRootElementName.getNamespaceURI().equals(name.getNamespaceURI())) continue;
            return true;
        }
        return false;
    }

    private QName parseFragmentRootElementName(String fragmentRootElementName) {
        String name = fragmentRootElementName;
        String nameSpace = null;
        if (fragmentRootElementName.contains("{")) {
            nameSpace = fragmentRootElementName.replaceAll("\\{(.*)\\}.*", "$1");
            name = fragmentRootElementName.replaceAll("\\{.*\\}(.*)", "$1");
        }
        return new QName(nameSpace, name, "");
    }
}

