/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.file.transform;

import java.util.Map;
import org.springframework.batch.infrastructure.item.file.transform.FieldSet;
import org.springframework.batch.infrastructure.item.file.transform.LineTokenizer;
import org.springframework.batch.infrastructure.support.PatternMatcher;
import org.springframework.util.Assert;

public class PatternMatchingCompositeLineTokenizer
implements LineTokenizer {
    private PatternMatcher<LineTokenizer> tokenizers;

    public PatternMatchingCompositeLineTokenizer(Map<String, LineTokenizer> tokenizers) {
        Assert.isTrue((!tokenizers.isEmpty() ? 1 : 0) != 0, (String)"The 'tokenizers' property must be non-empty");
        this.tokenizers = new PatternMatcher<LineTokenizer>(tokenizers);
    }

    @Override
    public FieldSet tokenize(String line) {
        return this.tokenizers.match(line).tokenize(line);
    }

    public void setTokenizers(Map<String, LineTokenizer> tokenizers) {
        Assert.isTrue((!tokenizers.isEmpty() ? 1 : 0) != 0, (String)"The 'tokenizers' property must be non-empty");
        this.tokenizers = new PatternMatcher<LineTokenizer>(tokenizers);
    }
}

