/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.file.builder;

import java.beans.PropertyEditor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.file.BufferedReaderFactory;
import org.springframework.batch.infrastructure.item.file.DefaultBufferedReaderFactory;
import org.springframework.batch.infrastructure.item.file.FlatFileItemReader;
import org.springframework.batch.infrastructure.item.file.LineCallbackHandler;
import org.springframework.batch.infrastructure.item.file.LineMapper;
import org.springframework.batch.infrastructure.item.file.mapping.BeanWrapperFieldSetMapper;
import org.springframework.batch.infrastructure.item.file.mapping.DefaultLineMapper;
import org.springframework.batch.infrastructure.item.file.mapping.FieldSetMapper;
import org.springframework.batch.infrastructure.item.file.mapping.RecordFieldSetMapper;
import org.springframework.batch.infrastructure.item.file.separator.RecordSeparatorPolicy;
import org.springframework.batch.infrastructure.item.file.separator.SimpleRecordSeparatorPolicy;
import org.springframework.batch.infrastructure.item.file.transform.DefaultFieldSetFactory;
import org.springframework.batch.infrastructure.item.file.transform.DelimitedLineTokenizer;
import org.springframework.batch.infrastructure.item.file.transform.FieldSetFactory;
import org.springframework.batch.infrastructure.item.file.transform.FixedLengthTokenizer;
import org.springframework.batch.infrastructure.item.file.transform.LineTokenizer;
import org.springframework.batch.infrastructure.item.file.transform.Range;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class FlatFileItemReaderBuilder<T> {
    protected Log logger = LogFactory.getLog(this.getClass());
    private boolean strict = true;
    private String encoding = FlatFileItemReader.DEFAULT_CHARSET;
    private RecordSeparatorPolicy recordSeparatorPolicy = new SimpleRecordSeparatorPolicy();
    private BufferedReaderFactory bufferedReaderFactory = new DefaultBufferedReaderFactory();
    private @Nullable Resource resource;
    private List<String> comments = new ArrayList<String>(Arrays.asList(FlatFileItemReader.DEFAULT_COMMENT_PREFIXES));
    private int linesToSkip = 0;
    private @Nullable LineCallbackHandler skippedLinesCallback;
    private @Nullable LineMapper<T> lineMapper;
    private @Nullable FieldSetMapper<T> fieldSetMapper;
    private @Nullable LineTokenizer lineTokenizer;
    private @Nullable DelimitedBuilder<T> delimitedBuilder;
    private @Nullable FixedLengthBuilder<T> fixedLengthBuilder;
    private @Nullable Class<T> targetType;
    private @Nullable String prototypeBeanName;
    private @Nullable BeanFactory beanFactory;
    private final Map<Class<?>, PropertyEditor> customEditors = new HashMap();
    private int distanceLimit = 5;
    private boolean beanMapperStrict = true;
    private BigInteger tokenizerValidator = new BigInteger("0");
    private boolean saveState = true;
    private @Nullable String name;
    private int maxItemCount = Integer.MAX_VALUE;
    private int currentItemCount;

    public FlatFileItemReaderBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public FlatFileItemReaderBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public FlatFileItemReaderBuilder<T> maxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public FlatFileItemReaderBuilder<T> currentItemCount(int currentItemCount) {
        this.currentItemCount = currentItemCount;
        return this;
    }

    public FlatFileItemReaderBuilder<T> addComment(String comment) {
        this.comments.add(comment);
        return this;
    }

    public FlatFileItemReaderBuilder<T> comments(String ... comments) {
        this.comments = Arrays.asList(comments);
        return this;
    }

    public FlatFileItemReaderBuilder<T> recordSeparatorPolicy(RecordSeparatorPolicy policy) {
        this.recordSeparatorPolicy = policy;
        return this;
    }

    public FlatFileItemReaderBuilder<T> bufferedReaderFactory(BufferedReaderFactory factory) {
        this.bufferedReaderFactory = factory;
        return this;
    }

    public FlatFileItemReaderBuilder<T> resource(Resource resource) {
        this.resource = resource;
        return this;
    }

    public FlatFileItemReaderBuilder<T> strict(boolean strict) {
        this.strict = strict;
        return this;
    }

    public FlatFileItemReaderBuilder<T> encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public FlatFileItemReaderBuilder<T> linesToSkip(int linesToSkip) {
        this.linesToSkip = linesToSkip;
        return this;
    }

    public FlatFileItemReaderBuilder<T> skippedLinesCallback(LineCallbackHandler callback) {
        this.skippedLinesCallback = callback;
        return this;
    }

    public FlatFileItemReaderBuilder<T> lineMapper(LineMapper<T> lineMapper) {
        this.lineMapper = lineMapper;
        return this;
    }

    public FlatFileItemReaderBuilder<T> fieldSetMapper(FieldSetMapper<T> mapper) {
        this.fieldSetMapper = mapper;
        return this;
    }

    public FlatFileItemReaderBuilder<T> lineTokenizer(LineTokenizer tokenizer) {
        this.tokenizerValidator = this.tokenizerValidator.flipBit(0);
        this.lineTokenizer = tokenizer;
        return this;
    }

    public DelimitedBuilder<T> delimited() {
        this.delimitedBuilder = new DelimitedBuilder(this);
        this.tokenizerValidator = this.tokenizerValidator.flipBit(1);
        return this.delimitedBuilder;
    }

    public FlatFileItemReaderBuilder<T> delimited(Consumer<DelimitedSpec<T>> config) {
        DelimitedSpecImpl spec = new DelimitedSpecImpl();
        config.accept(spec);
        DelimitedBuilder<T> builder = this.delimited();
        if (spec.delimiter != null) {
            builder.delimiter(spec.delimiter);
        }
        if (spec.quoteCharacter != null) {
            builder.quoteCharacter(spec.quoteCharacter.charValue());
        }
        if (!spec.names.isEmpty()) {
            builder.names(spec.names.toArray(new String[0]));
        }
        if (!spec.included.isEmpty()) {
            builder.includedFields(spec.included.toArray(new Integer[0]));
        }
        builder.fieldSetFactory(spec.fieldSetFactory);
        builder.strict(spec.strict);
        return this;
    }

    public FixedLengthBuilder<T> fixedLength() {
        this.fixedLengthBuilder = new FixedLengthBuilder(this);
        this.tokenizerValidator = this.tokenizerValidator.flipBit(2);
        return this.fixedLengthBuilder;
    }

    public FlatFileItemReaderBuilder<T> fixedLength(Consumer<FixedLengthSpec<T>> config) {
        FixedLengthSpecImpl spec = new FixedLengthSpecImpl();
        config.accept(spec);
        FixedLengthBuilder<T> builder = this.fixedLength();
        if (!spec.ranges.isEmpty()) {
            builder.columns(spec.ranges.toArray(new Range[0]));
        }
        if (!spec.names.isEmpty()) {
            builder.names(spec.names.toArray(new String[0]));
        }
        builder.fieldSetFactory(spec.fieldSetFactory);
        builder.strict(spec.strict);
        return this;
    }

    public FlatFileItemReaderBuilder<T> targetType(Class<T> targetType) {
        this.targetType = targetType;
        return this;
    }

    public FlatFileItemReaderBuilder<T> prototypeBeanName(String prototypeBeanName) {
        this.prototypeBeanName = prototypeBeanName;
        return this;
    }

    public FlatFileItemReaderBuilder<T> beanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        return this;
    }

    public FlatFileItemReaderBuilder<T> customEditors(Map<Class<?>, PropertyEditor> customEditors) {
        this.customEditors.putAll(customEditors);
        return this;
    }

    public FlatFileItemReaderBuilder<T> distanceLimit(int distanceLimit) {
        this.distanceLimit = distanceLimit;
        return this;
    }

    public FlatFileItemReaderBuilder<T> beanMapperStrict(boolean beanMapperStrict) {
        this.beanMapperStrict = beanMapperStrict;
        return this;
    }

    public FlatFileItemReader<T> build() {
        if (this.saveState) {
            Assert.state((boolean)StringUtils.hasText((String)this.name), (String)"A name is required when saveState is set to true.");
        }
        if (this.resource == null) {
            this.logger.debug((Object)"The resource is null.  This is only a valid scenario when injecting it later as in when using the MultiResourceItemReader");
        }
        Assert.notNull((Object)this.recordSeparatorPolicy, (String)"A RecordSeparatorPolicy is required.");
        Assert.notNull((Object)this.bufferedReaderFactory, (String)"A BufferedReaderFactory is required.");
        int validatorValue = this.tokenizerValidator.intValue();
        if (this.lineMapper == null) {
            Assert.state((validatorValue == 0 || validatorValue == 1 || validatorValue == 2 || validatorValue == 4 ? 1 : 0) != 0, (String)"Only one LineTokenizer option may be configured");
            DefaultLineMapper<T> lineMapper = new DefaultLineMapper<T>();
            if (this.lineTokenizer != null) {
                lineMapper.setLineTokenizer(this.lineTokenizer);
            } else if (this.fixedLengthBuilder != null) {
                lineMapper.setLineTokenizer(this.fixedLengthBuilder.build());
            } else if (this.delimitedBuilder != null) {
                lineMapper.setLineTokenizer(this.delimitedBuilder.build());
            } else {
                throw new IllegalStateException("No LineTokenizer implementation was provided.");
            }
            Assert.state((this.targetType == null || this.fieldSetMapper == null ? 1 : 0) != 0, (String)"Either a TargetType or FieldSetMapper can be set, can't be both.");
            if (this.targetType != null || StringUtils.hasText((String)this.prototypeBeanName)) {
                if (this.targetType != null && this.targetType.isRecord()) {
                    RecordFieldSetMapper<T> mapper = new RecordFieldSetMapper<T>(this.targetType);
                    lineMapper.setFieldSetMapper(mapper);
                } else {
                    BeanWrapperFieldSetMapper<T> mapper = new BeanWrapperFieldSetMapper<T>();
                    if (this.prototypeBeanName != null) {
                        mapper.setPrototypeBeanName(this.prototypeBeanName);
                    }
                    if (this.beanFactory != null) {
                        mapper.setBeanFactory(this.beanFactory);
                    }
                    if (this.targetType != null) {
                        mapper.setTargetType(this.targetType);
                    }
                    mapper.setStrict(this.beanMapperStrict);
                    mapper.setDistanceLimit(this.distanceLimit);
                    mapper.setCustomEditors(this.customEditors);
                    try {
                        mapper.afterPropertiesSet();
                        lineMapper.setFieldSetMapper(mapper);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Unable to initialize BeanWrapperFieldSetMapper", e);
                    }
                }
            } else if (this.fieldSetMapper != null) {
                lineMapper.setFieldSetMapper(this.fieldSetMapper);
            } else {
                throw new IllegalStateException("No FieldSetMapper implementation was provided.");
            }
            this.lineMapper = lineMapper;
        }
        FlatFileItemReader<T> reader = new FlatFileItemReader<T>(this.lineMapper);
        reader.setResource(this.resource);
        if (StringUtils.hasText((String)this.name)) {
            reader.setName(this.name);
        }
        if (StringUtils.hasText((String)this.encoding)) {
            reader.setEncoding(this.encoding);
        }
        reader.setLinesToSkip(this.linesToSkip);
        reader.setComments(this.comments.toArray(new String[0]));
        if (this.skippedLinesCallback != null) {
            reader.setSkippedLinesCallback(this.skippedLinesCallback);
        }
        reader.setRecordSeparatorPolicy(this.recordSeparatorPolicy);
        reader.setBufferedReaderFactory(this.bufferedReaderFactory);
        reader.setMaxItemCount(this.maxItemCount);
        reader.setCurrentItemCount(this.currentItemCount);
        reader.setSaveState(this.saveState);
        reader.setStrict(this.strict);
        return reader;
    }

    public static class DelimitedBuilder<T> {
        private final FlatFileItemReaderBuilder<T> parent;
        private final List<String> names = new ArrayList<String>();
        private @Nullable String delimiter;
        private @Nullable Character quoteCharacter;
        private final List<Integer> includedFields = new ArrayList<Integer>();
        private FieldSetFactory fieldSetFactory = new DefaultFieldSetFactory();
        private boolean strict = true;

        protected DelimitedBuilder(FlatFileItemReaderBuilder<T> parent) {
            this.parent = parent;
        }

        public DelimitedBuilder<T> delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public DelimitedBuilder<T> quoteCharacter(char quoteCharacter) {
            this.quoteCharacter = Character.valueOf(quoteCharacter);
            return this;
        }

        public DelimitedBuilder<T> includedFields(Integer ... fields) {
            this.includedFields.addAll(Arrays.asList(fields));
            return this;
        }

        public DelimitedBuilder<T> addIncludedField(int field) {
            this.includedFields.add(field);
            return this;
        }

        public DelimitedBuilder<T> fieldSetFactory(FieldSetFactory fieldSetFactory) {
            this.fieldSetFactory = fieldSetFactory;
            return this;
        }

        public FlatFileItemReaderBuilder<T> names(String ... names) {
            this.names.addAll(Arrays.asList(names));
            return this.parent;
        }

        public DelimitedBuilder<T> strict(boolean strict) {
            this.strict = strict;
            return this;
        }

        public DelimitedLineTokenizer build() {
            Assert.notNull((Object)this.fieldSetFactory, (String)"A FieldSetFactory is required.");
            Assert.notEmpty(this.names, (String)"A list of field names is required");
            DelimitedLineTokenizer tokenizer = new DelimitedLineTokenizer();
            tokenizer.setNames(this.names.toArray(new String[0]));
            if (StringUtils.hasLength((String)this.delimiter)) {
                tokenizer.setDelimiter(this.delimiter);
            }
            if (this.quoteCharacter != null) {
                tokenizer.setQuoteCharacter(this.quoteCharacter.charValue());
            }
            if (!this.includedFields.isEmpty()) {
                HashSet deDupedFields = CollectionUtils.newHashSet((int)this.includedFields.size());
                deDupedFields.addAll(this.includedFields);
                deDupedFields.remove(null);
                int[] fields = new int[deDupedFields.size()];
                Iterator iterator = deDupedFields.iterator();
                for (int i = 0; i < fields.length; ++i) {
                    fields[i] = (Integer)iterator.next();
                }
                tokenizer.setIncludedFields(fields);
            }
            tokenizer.setFieldSetFactory(this.fieldSetFactory);
            tokenizer.setStrict(this.strict);
            try {
                tokenizer.afterPropertiesSet();
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to initialize DelimitedLineTokenizer", e);
            }
            return tokenizer;
        }
    }

    private static class DelimitedSpecImpl<T>
    implements DelimitedSpec<T> {
        private final List<String> names = new ArrayList<String>();
        private @Nullable String delimiter;
        private @Nullable Character quoteCharacter;
        private final List<Integer> included = new ArrayList<Integer>();
        private FieldSetFactory fieldSetFactory = new DefaultFieldSetFactory();
        private boolean strict = true;

        private DelimitedSpecImpl() {
        }

        @Override
        public DelimitedSpec<T> delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        @Override
        public DelimitedSpec<T> quoteCharacter(char quoteCharacter) {
            this.quoteCharacter = Character.valueOf(quoteCharacter);
            return this;
        }

        @Override
        public DelimitedSpec<T> includedFields(Integer ... fields) {
            this.included.addAll(Arrays.asList(fields));
            return this;
        }

        @Override
        public DelimitedSpec<T> addIncludedField(int field) {
            this.included.add(field);
            return this;
        }

        @Override
        public DelimitedSpec<T> names(String ... names) {
            this.names.addAll(Arrays.asList(names));
            return this;
        }

        @Override
        public DelimitedSpec<T> fieldSetFactory(FieldSetFactory f) {
            this.fieldSetFactory = f;
            return this;
        }

        @Override
        public DelimitedSpec<T> strict(boolean strict) {
            this.strict = strict;
            return this;
        }
    }

    public static class FixedLengthBuilder<T> {
        private final FlatFileItemReaderBuilder<T> parent;
        private final List<Range> ranges = new ArrayList<Range>();
        private final List<String> names = new ArrayList<String>();
        private boolean strict = true;
        private FieldSetFactory fieldSetFactory = new DefaultFieldSetFactory();

        protected FixedLengthBuilder(FlatFileItemReaderBuilder<T> parent) {
            this.parent = parent;
        }

        public FixedLengthBuilder<T> columns(Range ... ranges) {
            this.ranges.addAll(Arrays.asList(ranges));
            return this;
        }

        public FixedLengthBuilder<T> addColumns(Range range) {
            this.ranges.add(range);
            return this;
        }

        public FixedLengthBuilder<T> addColumns(Range range, int index) {
            this.ranges.add(index, range);
            return this;
        }

        public FlatFileItemReaderBuilder<T> names(String ... names) {
            this.names.addAll(Arrays.asList(names));
            return this.parent;
        }

        public FixedLengthBuilder<T> strict(boolean strict) {
            this.strict = strict;
            return this;
        }

        public FixedLengthBuilder<T> fieldSetFactory(FieldSetFactory fieldSetFactory) {
            this.fieldSetFactory = fieldSetFactory;
            return this;
        }

        public FixedLengthTokenizer build() {
            Assert.notNull((Object)this.fieldSetFactory, (String)"A FieldSetFactory is required.");
            Assert.notEmpty(this.names, (String)"A list of field names is required.");
            Assert.notEmpty(this.ranges, (String)"A list of column ranges is required.");
            FixedLengthTokenizer tokenizer = new FixedLengthTokenizer(new Range[0]);
            tokenizer.setNames(this.names.toArray(new String[0]));
            tokenizer.setColumns(this.ranges.toArray(new Range[0]));
            tokenizer.setFieldSetFactory(this.fieldSetFactory);
            tokenizer.setStrict(this.strict);
            return tokenizer;
        }
    }

    private static class FixedLengthSpecImpl<T>
    implements FixedLengthSpec<T> {
        private final List<Range> ranges = new ArrayList<Range>();
        private final List<String> names = new ArrayList<String>();
        private boolean strict = true;
        private FieldSetFactory fieldSetFactory = new DefaultFieldSetFactory();

        private FixedLengthSpecImpl() {
        }

        @Override
        public FixedLengthSpec<T> columns(Range ... ranges) {
            this.ranges.addAll(Arrays.asList(ranges));
            return this;
        }

        @Override
        public FixedLengthSpec<T> addColumns(Range range) {
            this.ranges.add(range);
            return this;
        }

        @Override
        public FixedLengthSpec<T> addColumns(Range range, int index) {
            this.ranges.add(index, range);
            return this;
        }

        @Override
        public FixedLengthSpec<T> names(String ... names) {
            this.names.addAll(Arrays.asList(names));
            return this;
        }

        @Override
        public FixedLengthSpec<T> fieldSetFactory(FieldSetFactory f) {
            this.fieldSetFactory = f;
            return this;
        }

        @Override
        public FixedLengthSpec<T> strict(boolean strict) {
            this.strict = strict;
            return this;
        }
    }

    public static interface FixedLengthSpec<T> {
        public FixedLengthSpec<T> columns(Range ... var1);

        public FixedLengthSpec<T> addColumns(Range var1);

        public FixedLengthSpec<T> addColumns(Range var1, int var2);

        public FixedLengthSpec<T> names(String ... var1);

        public FixedLengthSpec<T> fieldSetFactory(FieldSetFactory var1);

        public FixedLengthSpec<T> strict(boolean var1);
    }

    public static interface DelimitedSpec<T> {
        public DelimitedSpec<T> delimiter(String var1);

        public DelimitedSpec<T> quoteCharacter(char var1);

        public DelimitedSpec<T> includedFields(Integer ... var1);

        public DelimitedSpec<T> addIncludedField(int var1);

        public DelimitedSpec<T> names(String ... var1);

        public DelimitedSpec<T> fieldSetFactory(FieldSetFactory var1);

        public DelimitedSpec<T> strict(boolean var1);
    }
}

