/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.repeat.context;

import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.batch.infrastructure.repeat.RepeatContext;
import org.springframework.util.Assert;

public class RepeatContextCounter {
    private final String countKey;
    private final RepeatContext context;

    public RepeatContextCounter(RepeatContext context, String countKey) {
        this(context, countKey, false);
    }

    public RepeatContextCounter(RepeatContext context, String countKey, boolean useParent) {
        Assert.notNull((Object)context, (String)"The context must be provided to initialize a counter");
        this.countKey = countKey;
        RepeatContext parent = context.getParent();
        RepeatContext repeatContext = this.context = useParent && parent != null ? parent : context;
        if (!this.context.hasAttribute(countKey)) {
            this.context.setAttribute(countKey, new AtomicInteger());
        }
    }

    public int getCount() {
        return this.getCounter().intValue();
    }

    public final void increment(int delta) {
        this.getCounter().addAndGet(delta);
    }

    public final void increment() {
        this.increment(1);
    }

    private AtomicInteger getCounter() {
        return (AtomicInteger)this.context.getAttribute(this.countKey);
    }
}

