/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.file.transform;

import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.file.transform.DefaultFieldSetFactory;
import org.springframework.batch.infrastructure.item.file.transform.FieldSet;
import org.springframework.batch.infrastructure.item.file.transform.FieldSetFactory;
import org.springframework.batch.infrastructure.item.file.transform.IncorrectTokenCountException;
import org.springframework.batch.infrastructure.item.file.transform.LineTokenizer;
import org.springframework.util.StringUtils;

public abstract class AbstractLineTokenizer
implements LineTokenizer {
    private static final String EMPTY_TOKEN = "";
    protected String[] names = new String[0];
    private boolean strict = true;
    private FieldSetFactory fieldSetFactory = new DefaultFieldSetFactory();

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    protected boolean isStrict() {
        return this.strict;
    }

    public void setFieldSetFactory(FieldSetFactory fieldSetFactory) {
        this.fieldSetFactory = fieldSetFactory;
    }

    public void setNames(String ... names) {
        boolean valid = false;
        for (String name : names) {
            if (!StringUtils.hasText((String)name)) continue;
            valid = true;
            break;
        }
        if (valid) {
            this.names = (String[])names.clone();
        }
    }

    public boolean hasNames() {
        return this.names.length > 0;
    }

    @Override
    public FieldSet tokenize(@Nullable String line) {
        if (line == null) {
            line = EMPTY_TOKEN;
        }
        ArrayList<String> tokens = new ArrayList<String>(this.doTokenize(line));
        if (this.names.length != 0 && !this.strict) {
            this.adjustTokenCountIfNecessary(tokens);
        }
        String[] values = tokens.toArray(new String[0]);
        if (this.names.length == 0) {
            return this.fieldSetFactory.create(values);
        }
        if (values.length != this.names.length) {
            throw new IncorrectTokenCountException(this.names.length, values.length, line);
        }
        return this.fieldSetFactory.create(values, this.names);
    }

    protected abstract List<String> doTokenize(String var1);

    private void adjustTokenCountIfNecessary(List<String> tokens) {
        int nameLength = this.names.length;
        int tokensSize = tokens.size();
        if (nameLength != tokensSize) {
            if (nameLength > tokensSize) {
                for (int i = 0; i < nameLength - tokensSize; ++i) {
                    tokens.add(EMPTY_TOKEN);
                }
            } else {
                tokens.subList(nameLength, tokensSize).clear();
            }
        }
    }
}

