/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.support;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.jspecify.annotations.Nullable;
import org.springframework.aop.framework.Advised;
import org.springframework.batch.infrastructure.support.MethodInvoker;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class SimpleMethodInvoker
implements MethodInvoker {
    private final Object object;
    private final Method method;

    public SimpleMethodInvoker(Object object, Method method) {
        Assert.notNull((Object)object, (String)"Object to invoke must not be null");
        Assert.notNull((Object)method, (String)"Method to invoke must not be null");
        this.method = method;
        this.object = object;
    }

    public SimpleMethodInvoker(Object object, String methodName, Class<?> ... paramTypes) {
        Assert.notNull((Object)object, (String)"Object to invoke must not be null");
        this.method = SimpleMethodInvoker.getMethodIfAvailable(object.getClass(), methodName, paramTypes);
        this.object = object;
    }

    private static Method getMethodIfAvailable(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        Method method = ClassUtils.getMethodIfAvailable(clazz, (String)methodName, (Class[])paramTypes);
        if (method == null) {
            method = ClassUtils.getMethodIfAvailable(clazz, (String)methodName, (Class[])new Class[0]);
        }
        if (method == null) {
            throw new IllegalArgumentException("No methods found for name: [" + methodName + "] in class: [" + String.valueOf(clazz) + "] with arguments of type: [" + Arrays.toString(paramTypes) + "]");
        }
        return method;
    }

    @Override
    public @Nullable Object invokeMethod(Object ... args) {
        Object[] invokeArgs;
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        if (parameterTypes.length == 0) {
            invokeArgs = new Object[]{};
        } else {
            if (parameterTypes.length != args.length) {
                throw new IllegalArgumentException("Wrong number of arguments, expected no more than: [" + parameterTypes.length + "]");
            }
            invokeArgs = args;
        }
        this.method.setAccessible(true);
        try {
            Object target = this.extractTarget(this.object, this.method);
            return this.method.invoke(target, invokeArgs);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to invoke method: [" + String.valueOf(this.method) + "] on object: [" + String.valueOf(this.object) + "] with arguments: [" + Arrays.toString(args) + "]", e);
        }
    }

    private Object extractTarget(Object target, Method method) {
        if (target instanceof Advised) {
            Object source;
            try {
                source = ((Advised)target).getTargetSource().getTarget();
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not extract target from proxy", e);
            }
            if (source instanceof Advised) {
                source = this.extractTarget(source, method);
            }
            if (method.getDeclaringClass().isAssignableFrom(source.getClass())) {
                target = source;
            }
        }
        return target;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SimpleMethodInvoker)) {
            return false;
        }
        SimpleMethodInvoker rhs = (SimpleMethodInvoker)obj;
        if (obj == this) {
            return true;
        }
        return rhs.method.equals(this.method) && rhs.object.equals(this.object);
    }

    public int hashCode() {
        int result = 25;
        result = 31 * result + this.object.hashCode();
        result = 31 * result + this.method.hashCode();
        return result;
    }
}

