/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.support;

import java.util.Iterator;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.ItemReader;
import org.springframework.util.Assert;

public class IteratorItemReader<T>
implements ItemReader<T> {
    private final Iterator<T> iterator;

    public IteratorItemReader(Iterable<T> iterable) {
        Assert.notNull(iterable, (String)"Iterable argument cannot be null!");
        this.iterator = iterable.iterator();
    }

    public IteratorItemReader(Iterator<T> iterator) {
        Assert.notNull(iterator, (String)"Iterator argument cannot be null!");
        this.iterator = iterator;
    }

    @Override
    public @Nullable T read() {
        if (this.iterator.hasNext()) {
            return this.iterator.next();
        }
        return null;
    }
}

