/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.repeat.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.repeat.CompletionPolicy;
import org.springframework.batch.infrastructure.repeat.RepeatCallback;
import org.springframework.batch.infrastructure.repeat.RepeatContext;
import org.springframework.batch.infrastructure.repeat.RepeatException;
import org.springframework.batch.infrastructure.repeat.RepeatListener;
import org.springframework.batch.infrastructure.repeat.RepeatOperations;
import org.springframework.batch.infrastructure.repeat.RepeatStatus;
import org.springframework.batch.infrastructure.repeat.exception.DefaultExceptionHandler;
import org.springframework.batch.infrastructure.repeat.exception.ExceptionHandler;
import org.springframework.batch.infrastructure.repeat.policy.DefaultResultCompletionPolicy;
import org.springframework.batch.infrastructure.repeat.support.RepeatInternalState;
import org.springframework.batch.infrastructure.repeat.support.RepeatInternalStateSupport;
import org.springframework.batch.infrastructure.repeat.support.RepeatSynchronizationManager;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;

public class RepeatTemplate
implements RepeatOperations {
    protected Log logger = LogFactory.getLog(this.getClass());
    private RepeatListener[] listeners = new RepeatListener[0];
    private CompletionPolicy completionPolicy = new DefaultResultCompletionPolicy();
    private ExceptionHandler exceptionHandler = new DefaultExceptionHandler();

    public void setListeners(RepeatListener[] listeners) {
        this.listeners = (RepeatListener[])listeners.clone();
    }

    public void registerListener(RepeatListener listener) {
        ArrayList<RepeatListener> list = new ArrayList<RepeatListener>(Arrays.asList(this.listeners));
        list.add(listener);
        this.listeners = list.toArray(new RepeatListener[0]);
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setCompletionPolicy(CompletionPolicy terminationPolicy) {
        Assert.notNull((Object)terminationPolicy, (String)"CompletionPolicy is required");
        this.completionPolicy = terminationPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RepeatStatus iterate(RepeatCallback callback) {
        RepeatContext outer = RepeatSynchronizationManager.getContext();
        RepeatStatus result = RepeatStatus.CONTINUABLE;
        try {
            result = this.executeInternal(callback);
        }
        finally {
            RepeatSynchronizationManager.clear();
            if (outer != null) {
                RepeatSynchronizationManager.register(outer);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RepeatStatus executeInternal(RepeatCallback callback) {
        RepeatContext context = this.start();
        boolean running = !this.isMarkedComplete(context);
        for (RepeatListener interceptor : this.listeners) {
            interceptor.open(context);
            boolean bl = running = running && !this.isMarkedComplete(context);
            if (!running) break;
        }
        RepeatStatus result = RepeatStatus.CONTINUABLE;
        RepeatInternalState state = this.createInternalState(context);
        Collection<Throwable> throwables = state.getThrowables();
        ArrayList<Throwable> deferred = new ArrayList<Throwable>();
        try {
            while (running) {
                for (RepeatListener interceptor : this.listeners) {
                    interceptor.before(context);
                    running = running && !this.isMarkedComplete(context);
                }
                if (!running) continue;
                try {
                    result = this.getNextResult(context, callback, state);
                    this.executeAfterInterceptors(context, result);
                }
                catch (Throwable throwable) {
                    this.doHandle(throwable, context, deferred);
                }
                if (!this.isComplete(context, result) && !this.isMarkedComplete(context) && deferred.isEmpty()) continue;
                running = false;
            }
            result = result.and(this.waitForResults(state));
            for (Throwable throwable : throwables) {
                this.doHandle(throwable, context, deferred);
            }
            state = null;
        }
        finally {
            try {
                if (!deferred.isEmpty()) {
                    Throwable throwable = (Throwable)deferred.iterator().next();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Handling fatal exception explicitly (rethrowing first of " + deferred.size() + "): " + throwable.getClass().getName() + ": " + throwable.getMessage()));
                    }
                    RepeatTemplate.rethrow(throwable);
                }
            }
            finally {
                try {
                    int i = this.listeners.length;
                    while (i-- > 0) {
                        RepeatListener interceptor = this.listeners[i];
                        interceptor.close(context);
                    }
                }
                finally {
                    context.close();
                }
            }
        }
        return result;
    }

    private void doHandle(Throwable throwable, RepeatContext context, Collection<Throwable> deferred) {
        Throwable unwrappedThrowable = RepeatTemplate.unwrapIfRethrown(throwable);
        try {
            int i = this.listeners.length;
            while (i-- > 0) {
                RepeatListener interceptor = this.listeners[i];
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Exception intercepted (" + (i + 1) + " of " + this.listeners.length + ")"), unwrappedThrowable);
                }
                interceptor.onError(context, unwrappedThrowable);
            }
            if (this.logger.isDebugEnabled()) {
                StringBuilder message = new StringBuilder("Handling exception: ").append(throwable.getClass().getName());
                if (unwrappedThrowable != throwable) {
                    message.append(", caused by: ").append(unwrappedThrowable.getClass().getName()).append(": ").append(unwrappedThrowable.getMessage());
                }
                this.logger.debug((Object)message.toString());
            }
            this.exceptionHandler.handleException(context, unwrappedThrowable);
        }
        catch (Throwable handled) {
            deferred.add(handled);
        }
    }

    private static void rethrow(Throwable throwable) throws RuntimeException {
        if (throwable instanceof Error) {
            Error error = (Error)throwable;
            throw error;
        }
        if (throwable instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)throwable;
            throw runtimeException;
        }
        throw new RepeatException("Exception in batch process", throwable);
    }

    private static Throwable unwrapIfRethrown(Throwable throwable) {
        return throwable instanceof RepeatException && throwable.getCause() != null ? throwable.getCause() : throwable;
    }

    protected RepeatInternalState createInternalState(RepeatContext context) {
        return new RepeatInternalStateSupport();
    }

    protected RepeatStatus getNextResult(RepeatContext context, RepeatCallback callback, RepeatInternalState state) throws Throwable {
        this.update(context);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Repeat operation about to start at count=" + context.getStartedCount()));
        }
        return callback.doInIteration(context);
    }

    protected boolean waitForResults(RepeatInternalState state) {
        return true;
    }

    @Contract(value="null -> false")
    protected final boolean canContinue(@Nullable RepeatStatus value) {
        return value != null && value.isContinuable();
    }

    private boolean isMarkedComplete(RepeatContext context) {
        boolean complete = context.isCompleteOnly();
        if (context.getParent() != null) {
            boolean bl = complete = complete || this.isMarkedComplete(context.getParent());
        }
        if (complete) {
            this.logger.debug((Object)"Repeat is complete according to context alone.");
        }
        return complete;
    }

    protected void executeAfterInterceptors(RepeatContext context, @Nullable RepeatStatus value) {
        if (this.canContinue(value)) {
            int i = this.listeners.length;
            while (i-- > 0) {
                RepeatListener interceptor = this.listeners[i];
                interceptor.after(context, value);
            }
        }
    }

    protected boolean isComplete(RepeatContext context, RepeatStatus result) {
        boolean complete = this.completionPolicy.isComplete(context, result);
        if (complete) {
            this.logger.debug((Object)"Repeat is complete according to policy and result value.");
        }
        return complete;
    }

    protected boolean isComplete(RepeatContext context) {
        boolean complete = this.completionPolicy.isComplete(context);
        if (complete) {
            this.logger.debug((Object)"Repeat is complete according to policy alone not including result.");
        }
        return complete;
    }

    protected RepeatContext start() {
        RepeatContext parent = RepeatSynchronizationManager.getContext();
        RepeatContext context = this.completionPolicy.start(parent);
        RepeatSynchronizationManager.register(context);
        this.logger.debug((Object)"Starting repeat context.");
        return context;
    }

    protected void update(RepeatContext context) {
        this.completionPolicy.update(context);
    }
}

