/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.springframework.batch.infrastructure.item.ItemStreamException;
import org.springframework.util.Assert;

public abstract class FileUtils {
    private FileUtils() {
    }

    public static void setUpOutputFile(File file, boolean restarted, boolean append, boolean overwriteOutputFile) {
        block13: {
            Assert.notNull((Object)file, (String)"An output file is required");
            try {
                if (restarted) break block13;
                if (!append) {
                    if (file.exists()) {
                        if (!overwriteOutputFile) {
                            throw new ItemStreamException("File already exists: [" + file.getAbsolutePath() + "]");
                        }
                        try {
                            Files.delete(file.toPath());
                        }
                        catch (IOException | SecurityException e) {
                            throw new IOException("Could not delete file: " + String.valueOf(file), e);
                        }
                    }
                    if (file.getParent() != null) {
                        new File(file.getParent()).mkdirs();
                    }
                    if (!FileUtils.createNewFile(file)) {
                        throw new ItemStreamException("Output file was not created: [" + file.getAbsolutePath() + "]");
                    }
                    break block13;
                }
                if (!file.exists()) {
                    if (file.getParent() != null) {
                        new File(file.getParent()).mkdirs();
                    }
                    if (!FileUtils.createNewFile(file)) {
                        throw new ItemStreamException("Output file was not created: [" + file.getAbsolutePath() + "]");
                    }
                }
            }
            catch (IOException ioe) {
                throw new ItemStreamException("Unable to create file: [" + file.getAbsolutePath() + "]", ioe);
            }
        }
        if (!file.canWrite()) {
            throw new ItemStreamException("File is not writable: [" + file.getAbsolutePath() + "]");
        }
    }

    public static boolean createNewFile(File file) throws IOException {
        if (file.exists()) {
            return false;
        }
        try {
            return file.createNewFile() && file.exists();
        }
        catch (IOException e) {
            if (file.exists()) {
                return true;
            }
            throw e;
        }
    }
}

