/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.support;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.ExecutionContext;
import org.springframework.batch.infrastructure.item.ItemStreamReader;
import org.springframework.util.Assert;

public class SynchronizedItemStreamReader<T>
implements ItemStreamReader<T> {
    private ItemStreamReader<T> delegate;
    private final Lock lock = new ReentrantLock();

    public SynchronizedItemStreamReader(ItemStreamReader<T> delegate) {
        Assert.notNull(delegate, (String)"The delegate item reader must not be null");
        this.delegate = delegate;
    }

    public void setDelegate(ItemStreamReader<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public @Nullable T read() throws Exception {
        this.lock.lock();
        try {
            Object t = this.delegate.read();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public void open(ExecutionContext executionContext) {
        this.delegate.open(executionContext);
    }

    @Override
    public void update(ExecutionContext executionContext) {
        this.delegate.update(executionContext);
    }
}

